<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentDetailType StructType
 * @subpackage Structs
 */
class PaymentDetailType extends AbstractStructBase
{
    /**
     * The FOP
     * Meta information extracted from the WSDL
     * - documentation: Form of Payment
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\FOPType
     */
    public $FOP;
    /**
     * The PaymentCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\PaymentCard
     */
    public $PaymentCard;
    /**
     * The AmountDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\AmountDetail
     */
    public $AmountDetail;
    /**
     * The AuthorizationResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\AuthorizationResult
     */
    public $AuthorizationResult;
    /**
     * The AccountValidationResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\AccountValidationResult
     */
    public $AccountValidationResult;
    /**
     * The CardUsageResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\CardUsageResult
     */
    public $CardUsageResult;
    /**
     * The ReturnURLs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\ReturnURLsType
     */
    public $ReturnURLs;
    /**
     * The RoutingDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\RoutingDetail
     */
    public $RoutingDetail;
    /**
     * The AdditionalDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\AdditionalDetailType
     */
    public $AdditionalDetail;
    /**
     * The InstallmentDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\InstallmentDetail
     */
    public $InstallmentDetail;
    /**
     * The VirtualPaymentDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\VirtualPaymentDetail
     */
    public $VirtualPaymentDetail;
    /**
     * The FOP_RPH
     * @var string
     */
    public $FOP_RPH;
    /**
     * The PaymentRef
     * @var string
     */
    public $PaymentRef;
    /**
     * The DeferredPaymentPeriod
     * @var string
     */
    public $DeferredPaymentPeriod;
    /**
     * Constructor method for PaymentDetailType
     * @uses PaymentDetailType::setFOP()
     * @uses PaymentDetailType::setPaymentCard()
     * @uses PaymentDetailType::setAmountDetail()
     * @uses PaymentDetailType::setAuthorizationResult()
     * @uses PaymentDetailType::setAccountValidationResult()
     * @uses PaymentDetailType::setCardUsageResult()
     * @uses PaymentDetailType::setReturnURLs()
     * @uses PaymentDetailType::setRoutingDetail()
     * @uses PaymentDetailType::setAdditionalDetail()
     * @uses PaymentDetailType::setInstallmentDetail()
     * @uses PaymentDetailType::setVirtualPaymentDetail()
     * @uses PaymentDetailType::setFOP_RPH()
     * @uses PaymentDetailType::setPaymentRef()
     * @uses PaymentDetailType::setDeferredPaymentPeriod()
     * @param \SabrePaymentGateway\StructType\FOPType $fOP
     * @param \SabrePaymentGateway\StructType\PaymentCard $paymentCard
     * @param \SabrePaymentGateway\StructType\AmountDetail $amountDetail
     * @param \SabrePaymentGateway\StructType\AuthorizationResult $authorizationResult
     * @param \SabrePaymentGateway\StructType\AccountValidationResult $accountValidationResult
     * @param \SabrePaymentGateway\StructType\CardUsageResult $cardUsageResult
     * @param \SabrePaymentGateway\StructType\ReturnURLsType $returnURLs
     * @param \SabrePaymentGateway\StructType\RoutingDetail $routingDetail
     * @param \SabrePaymentGateway\StructType\AdditionalDetailType $additionalDetail
     * @param \SabrePaymentGateway\StructType\InstallmentDetail $installmentDetail
     * @param \SabrePaymentGateway\StructType\VirtualPaymentDetail $virtualPaymentDetail
     * @param string $fOP_RPH
     * @param string $paymentRef
     * @param string $deferredPaymentPeriod
     */
    public function __construct(\SabrePaymentGateway\StructType\FOPType $fOP = null, \SabrePaymentGateway\StructType\PaymentCard $paymentCard = null, \SabrePaymentGateway\StructType\AmountDetail $amountDetail = null, \SabrePaymentGateway\StructType\AuthorizationResult $authorizationResult = null, \SabrePaymentGateway\StructType\AccountValidationResult $accountValidationResult = null, \SabrePaymentGateway\StructType\CardUsageResult $cardUsageResult = null, \SabrePaymentGateway\StructType\ReturnURLsType $returnURLs = null, \SabrePaymentGateway\StructType\RoutingDetail $routingDetail = null, \SabrePaymentGateway\StructType\AdditionalDetailType $additionalDetail = null, \SabrePaymentGateway\StructType\InstallmentDetail $installmentDetail = null, \SabrePaymentGateway\StructType\VirtualPaymentDetail $virtualPaymentDetail = null, $fOP_RPH = null, $paymentRef = null, $deferredPaymentPeriod = null)
    {
        $this
            ->setFOP($fOP)
            ->setPaymentCard($paymentCard)
            ->setAmountDetail($amountDetail)
            ->setAuthorizationResult($authorizationResult)
            ->setAccountValidationResult($accountValidationResult)
            ->setCardUsageResult($cardUsageResult)
            ->setReturnURLs($returnURLs)
            ->setRoutingDetail($routingDetail)
            ->setAdditionalDetail($additionalDetail)
            ->setInstallmentDetail($installmentDetail)
            ->setVirtualPaymentDetail($virtualPaymentDetail)
            ->setFOP_RPH($fOP_RPH)
            ->setPaymentRef($paymentRef)
            ->setDeferredPaymentPeriod($deferredPaymentPeriod);
    }
    /**
     * Get FOP value
     * @return \SabrePaymentGateway\StructType\FOPType|null
     */
    public function getFOP()
    {
        return $this->FOP;
    }
    /**
     * Set FOP value
     * @param \SabrePaymentGateway\StructType\FOPType $fOP
     * @return \SabrePaymentGateway\StructType\PaymentDetailType
     */
    public function setFOP(\SabrePaymentGateway\StructType\FOPType $fOP = null)
    {
        $this->FOP = $fOP;
        return $this;
    }
    /**
     * Get PaymentCard value
     * @return \SabrePaymentGateway\StructType\PaymentCard|null
     */
    public function getPaymentCard()
    {
        return $this->PaymentCard;
    }
    /**
     * Set PaymentCard value
     * @param \SabrePaymentGateway\StructType\PaymentCard $paymentCard
     * @return \SabrePaymentGateway\StructType\PaymentDetailType
     */
    public function setPaymentCard(\SabrePaymentGateway\StructType\PaymentCard $paymentCard = null)
    {
        $this->PaymentCard = $paymentCard;
        return $this;
    }
    /**
     * Get AmountDetail value
     * @return \SabrePaymentGateway\StructType\AmountDetail|null
     */
    public function getAmountDetail()
    {
        return $this->AmountDetail;
    }
    /**
     * Set AmountDetail value
     * @param \SabrePaymentGateway\StructType\AmountDetail $amountDetail
     * @return \SabrePaymentGateway\StructType\PaymentDetailType
     */
    public function setAmountDetail(\SabrePaymentGateway\StructType\AmountDetail $amountDetail = null)
    {
        $this->AmountDetail = $amountDetail;
        return $this;
    }
    /**
     * Get AuthorizationResult value
     * @return \SabrePaymentGateway\StructType\AuthorizationResult|null
     */
    public function getAuthorizationResult()
    {
        return $this->AuthorizationResult;
    }
    /**
     * Set AuthorizationResult value
     * @param \SabrePaymentGateway\StructType\AuthorizationResult $authorizationResult
     * @return \SabrePaymentGateway\StructType\PaymentDetailType
     */
    public function setAuthorizationResult(\SabrePaymentGateway\StructType\AuthorizationResult $authorizationResult = null)
    {
        $this->AuthorizationResult = $authorizationResult;
        return $this;
    }
    /**
     * Get AccountValidationResult value
     * @return \SabrePaymentGateway\StructType\AccountValidationResult|null
     */
    public function getAccountValidationResult()
    {
        return $this->AccountValidationResult;
    }
    /**
     * Set AccountValidationResult value
     * @param \SabrePaymentGateway\StructType\AccountValidationResult $accountValidationResult
     * @return \SabrePaymentGateway\StructType\PaymentDetailType
     */
    public function setAccountValidationResult(\SabrePaymentGateway\StructType\AccountValidationResult $accountValidationResult = null)
    {
        $this->AccountValidationResult = $accountValidationResult;
        return $this;
    }
    /**
     * Get CardUsageResult value
     * @return \SabrePaymentGateway\StructType\CardUsageResult|null
     */
    public function getCardUsageResult()
    {
        return $this->CardUsageResult;
    }
    /**
     * Set CardUsageResult value
     * @param \SabrePaymentGateway\StructType\CardUsageResult $cardUsageResult
     * @return \SabrePaymentGateway\StructType\PaymentDetailType
     */
    public function setCardUsageResult(\SabrePaymentGateway\StructType\CardUsageResult $cardUsageResult = null)
    {
        $this->CardUsageResult = $cardUsageResult;
        return $this;
    }
    /**
     * Get ReturnURLs value
     * @return \SabrePaymentGateway\StructType\ReturnURLsType|null
     */
    public function getReturnURLs()
    {
        return $this->ReturnURLs;
    }
    /**
     * Set ReturnURLs value
     * @param \SabrePaymentGateway\StructType\ReturnURLsType $returnURLs
     * @return \SabrePaymentGateway\StructType\PaymentDetailType
     */
    public function setReturnURLs(\SabrePaymentGateway\StructType\ReturnURLsType $returnURLs = null)
    {
        $this->ReturnURLs = $returnURLs;
        return $this;
    }
    /**
     * Get RoutingDetail value
     * @return \SabrePaymentGateway\StructType\RoutingDetail|null
     */
    public function getRoutingDetail()
    {
        return $this->RoutingDetail;
    }
    /**
     * Set RoutingDetail value
     * @param \SabrePaymentGateway\StructType\RoutingDetail $routingDetail
     * @return \SabrePaymentGateway\StructType\PaymentDetailType
     */
    public function setRoutingDetail(\SabrePaymentGateway\StructType\RoutingDetail $routingDetail = null)
    {
        $this->RoutingDetail = $routingDetail;
        return $this;
    }
    /**
     * Get AdditionalDetail value
     * @return \SabrePaymentGateway\StructType\AdditionalDetailType|null
     */
    public function getAdditionalDetail()
    {
        return $this->AdditionalDetail;
    }
    /**
     * Set AdditionalDetail value
     * @param \SabrePaymentGateway\StructType\AdditionalDetailType $additionalDetail
     * @return \SabrePaymentGateway\StructType\PaymentDetailType
     */
    public function setAdditionalDetail(\SabrePaymentGateway\StructType\AdditionalDetailType $additionalDetail = null)
    {
        $this->AdditionalDetail = $additionalDetail;
        return $this;
    }
    /**
     * Get InstallmentDetail value
     * @return \SabrePaymentGateway\StructType\InstallmentDetail|null
     */
    public function getInstallmentDetail()
    {
        return $this->InstallmentDetail;
    }
    /**
     * Set InstallmentDetail value
     * @param \SabrePaymentGateway\StructType\InstallmentDetail $installmentDetail
     * @return \SabrePaymentGateway\StructType\PaymentDetailType
     */
    public function setInstallmentDetail(\SabrePaymentGateway\StructType\InstallmentDetail $installmentDetail = null)
    {
        $this->InstallmentDetail = $installmentDetail;
        return $this;
    }
    /**
     * Get VirtualPaymentDetail value
     * @return \SabrePaymentGateway\StructType\VirtualPaymentDetail|null
     */
    public function getVirtualPaymentDetail()
    {
        return $this->VirtualPaymentDetail;
    }
    /**
     * Set VirtualPaymentDetail value
     * @param \SabrePaymentGateway\StructType\VirtualPaymentDetail $virtualPaymentDetail
     * @return \SabrePaymentGateway\StructType\PaymentDetailType
     */
    public function setVirtualPaymentDetail(\SabrePaymentGateway\StructType\VirtualPaymentDetail $virtualPaymentDetail = null)
    {
        $this->VirtualPaymentDetail = $virtualPaymentDetail;
        return $this;
    }
    /**
     * Get FOP_RPH value
     * @return string|null
     */
    public function getFOP_RPH()
    {
        return $this->FOP_RPH;
    }
    /**
     * Set FOP_RPH value
     * @param string $fOP_RPH
     * @return \SabrePaymentGateway\StructType\PaymentDetailType
     */
    public function setFOP_RPH($fOP_RPH = null)
    {
        // validation for constraint: string
        if (!is_null($fOP_RPH) && !is_string($fOP_RPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fOP_RPH, true), gettype($fOP_RPH)), __LINE__);
        }
        $this->FOP_RPH = $fOP_RPH;
        return $this;
    }
    /**
     * Get PaymentRef value
     * @return string|null
     */
    public function getPaymentRef()
    {
        return $this->PaymentRef;
    }
    /**
     * Set PaymentRef value
     * @param string $paymentRef
     * @return \SabrePaymentGateway\StructType\PaymentDetailType
     */
    public function setPaymentRef($paymentRef = null)
    {
        // validation for constraint: string
        if (!is_null($paymentRef) && !is_string($paymentRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentRef, true), gettype($paymentRef)), __LINE__);
        }
        $this->PaymentRef = $paymentRef;
        return $this;
    }
    /**
     * Get DeferredPaymentPeriod value
     * @return string|null
     */
    public function getDeferredPaymentPeriod()
    {
        return $this->DeferredPaymentPeriod;
    }
    /**
     * Set DeferredPaymentPeriod value
     * @param string $deferredPaymentPeriod
     * @return \SabrePaymentGateway\StructType\PaymentDetailType
     */
    public function setDeferredPaymentPeriod($deferredPaymentPeriod = null)
    {
        // validation for constraint: string
        if (!is_null($deferredPaymentPeriod) && !is_string($deferredPaymentPeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deferredPaymentPeriod, true), gettype($deferredPaymentPeriod)), __LINE__);
        }
        $this->DeferredPaymentPeriod = $deferredPaymentPeriod;
        return $this;
    }
}
