<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentCardType StructType
 * Meta information extracted from the WSDL
 * - documentation: Identification about a specific credit card
 * @subpackage Structs
 */
class PaymentCardType extends AbstractStructBase
{
    /**
     * The DCC
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\DCCType
     */
    public $DCC;
    /**
     * The T3DS
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\T3DS
     */
    public $T3DS;
    /**
     * The CardReader
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\CardReader
     */
    public $CardReader;
    /**
     * The CardHolderName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\CardHolderName
     */
    public $CardHolderName;
    /**
     * The Identifications
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\Identifications
     */
    public $Identifications;
    /**
     * The Gender
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Gender;
    /**
     * The FrequentFlyerID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FrequentFlyerID;
    /**
     * The CardIssuerName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\CardIssuerName
     */
    public $CardIssuerName;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - documentation: Card holder's address.
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\AddressType
     */
    public $Address;
    /**
     * The EmailAddress
     * Meta information extracted from the WSDL
     * - documentation: Card holder's email address
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var string[]
     */
    public $EmailAddress;
    /**
     * The PhoneNumber
     * Meta information extracted from the WSDL
     * - documentation: Card holder's phone numbers
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\PhoneType[]
     */
    public $PhoneNumber;
    /**
     * The DOB
     * Meta information extracted from the WSDL
     * - documentation: Date of Birth in YYYY-MM-DD format
     * - minOccurs: 0
     * @var string
     */
    public $DOB;
    /**
     * The SSN
     * Meta information extracted from the WSDL
     * - documentation: Last 4 Social Sec Number
     * - minOccurs: 0
     * @var string
     */
    public $SSN;
    /**
     * The Authenticated
     * Meta information extracted from the WSDL
     * - documentation: Indicates if customer logged into merchant website successfully.
     * - minOccurs: 0
     * @var bool
     */
    public $Authenticated;
    /**
     * The CustomerType
     * Meta information extracted from the WSDL
     * - documentation: "N" - New "E" - Existing
     * - minOccurs: 0
     * @var string
     */
    public $CustomerType;
    /**
     * The VCL_Info
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\VCL_Info
     */
    public $VCL_Info;
    /**
     * The ApplePayCryptogram
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ApplePayCryptogram;
    /**
     * The VirtualCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\VirtualCard
     */
    public $VirtualCard;
    /**
     * The LoyaltyMemberDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\LoyaltyMembershipDetailType
     */
    public $LoyaltyMemberDetail;
    /**
     * The CardType
     * Meta information extracted from the WSDL
     * - documentation: Indicates the type of magnetic striped card. Refer to OTA Code ListCard Type (CDT). | Used for codes in the OTA code tables.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}
     * - use: optional
     * @var string
     */
    public $CardType;
    /**
     * The CardCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CardCode;
    /**
     * The InputCardCode
     * Meta information extracted from the WSDL
     * - documentation: Indicates the original input card code for internal processing.
     * - use: optional
     * @var string
     */
    public $InputCardCode;
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - documentation: Credit card number embossed on the card.
     * - use: optional
     * @var string
     */
    public $CardNumber;
    /**
     * The IssueNumber
     * Meta information extracted from the WSDL
     * - documentation: 1 to 2 digits Issue Number on certain cards such as Maestro.
     * - use: optional
     * @var string
     */
    public $IssueNumber;
    /**
     * The PIN
     * Meta information extracted from the WSDL
     * - documentation: Personal Idetification Number
     * - use: optional
     * @var string
     */
    public $PIN;
    /**
     * The CardSecurityCode
     * Meta information extracted from the WSDL
     * - documentation: Verification digits printed on the card following the embossed number. This may also accommodate the customer identification/batch number (CID), card verification value (CVV2 ), card validation code number (CVC2) on credit card.
     * - use: optional
     * @var string
     */
    public $CardSecurityCode;
    /**
     * The T3DS_Ind
     * Meta information extracted from the WSDL
     * - documentation: 3DS Indicator
     * - use: optional
     * @var bool
     */
    public $T3DS_Ind;
    /**
     * The Trigger3DS
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether to invoke standalone 3DS
     * - use: optional
     * @var bool
     */
    public $Trigger3DS;
    /**
     * The Bypass3DS
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether to bypass standalone 3DS
     * - use: optional
     * @var bool
     */
    public $Bypass3DS;
    /**
     * The ReadyFor3DSVersion
     * Meta information extracted from the WSDL
     * - documentation: Indicates 3DS version integration readiness (e.g. 2.1)
     * - use: optional
     * @var string
     */
    public $ReadyFor3DSVersion;
    /**
     * The AuthenticationExemptionCode
     * Meta information extracted from the WSDL
     * - documentation: Indicates Strong Customer Authentication (SCA) Exemption Code
     * - use: optional
     * @var string
     */
    public $AuthenticationExemptionCode;
    /**
     * The ApplePayInd
     * Meta information extracted from the WSDL
     * - documentation: Apple Pay Indicator
     * - use: optional
     * @var bool
     */
    public $ApplePayInd;
    /**
     * The EffectiveDate
     * Meta information extracted from the WSDL
     * - documentation: Indicates the starting date. Use YYYY-MM-DD format.
     * - use: optional
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * Meta information extracted from the WSDL
     * - documentation: Indicates the ending date.
     * - use: optional
     * @var string
     */
    public $ExpireDate;
    /**
     * The MaskedCardNumber
     * Meta information extracted from the WSDL
     * - documentation: May be used to send a concealed credit card number (e.g., xxxxxxxxxxxx9922).
     * - use: optional
     * @var string
     */
    public $MaskedCardNumber;
    /**
     * The TokenizedCardNumber
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $TokenizedCardNumber;
    /**
     * The EncryptedCardNumber
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $EncryptedCardNumber;
    /**
     * The ExtendPayment
     * Meta information extracted from the WSDL
     * - documentation: Number of months or installments.
     * - use: optional
     * @var string
     */
    public $ExtendPayment;
    /**
     * The Track1
     * Meta information extracted from the WSDL
     * - documentation: Track 1 Mag Stripe Data
     * - use: optional
     * @var string
     */
    public $Track1;
    /**
     * The Track2
     * Meta information extracted from the WSDL
     * - documentation: Track 2 Mag Stripe Data
     * - use: optional
     * @var string
     */
    public $Track2;
    /**
     * The ReturnTokenInd
     * Meta information extracted from the WSDL
     * - documentation: If true, TokenizedCardNumber will be returned in PaymentRS.
     * - use: optional
     * @var bool
     */
    public $ReturnTokenInd;
    /**
     * The StoredCredentialTransactionInd
     * Meta information extracted from the WSDL
     * - documentation: Indicates Merchant Initiated Transaction (MIT) where merchant submits a transaction using previously stored details, without the cardholder's participation
     * - use: optional
     * @var bool
     */
    public $StoredCredentialTransactionInd;
    /**
     * The NetworkTransactionReference
     * Meta information extracted from the WSDL
     * - documentation: Transaction ID that supports merchant-initiated transaction (MIT) exemptions
     * - use: optional
     * @var string
     */
    public $NetworkTransactionReference;
    /**
     * The ApplePayMerchantID
     * Meta information extracted from the WSDL
     * - documentation: Registered Apple Pay merchant ID that identifies merchant to Apple Pay as being able to accept payments. A Payment Processing certificate that is associated with the merchant ID is used to encrypt payment information.
     * - use: optional
     * @var string
     */
    public $ApplePayMerchantID;
    /**
     * The TokenCryptogram
     * Meta information extracted from the WSDL
     * - documentation: Token Cryptograms generated by Network vendor - Token Authentication Verification Value (TAVV)
     * - use: optional
     * @var string
     */
    public $TokenCryptogram;
    /**
     * Constructor method for PaymentCardType
     * @uses PaymentCardType::setDCC()
     * @uses PaymentCardType::setT3DS()
     * @uses PaymentCardType::setCardReader()
     * @uses PaymentCardType::setCardHolderName()
     * @uses PaymentCardType::setIdentifications()
     * @uses PaymentCardType::setGender()
     * @uses PaymentCardType::setFrequentFlyerID()
     * @uses PaymentCardType::setCardIssuerName()
     * @uses PaymentCardType::setAddress()
     * @uses PaymentCardType::setEmailAddress()
     * @uses PaymentCardType::setPhoneNumber()
     * @uses PaymentCardType::setDOB()
     * @uses PaymentCardType::setSSN()
     * @uses PaymentCardType::setAuthenticated()
     * @uses PaymentCardType::setCustomerType()
     * @uses PaymentCardType::setVCL_Info()
     * @uses PaymentCardType::setApplePayCryptogram()
     * @uses PaymentCardType::setVirtualCard()
     * @uses PaymentCardType::setLoyaltyMemberDetail()
     * @uses PaymentCardType::setCardType()
     * @uses PaymentCardType::setCardCode()
     * @uses PaymentCardType::setInputCardCode()
     * @uses PaymentCardType::setCardNumber()
     * @uses PaymentCardType::setIssueNumber()
     * @uses PaymentCardType::setPIN()
     * @uses PaymentCardType::setCardSecurityCode()
     * @uses PaymentCardType::setT3DS_Ind()
     * @uses PaymentCardType::setTrigger3DS()
     * @uses PaymentCardType::setBypass3DS()
     * @uses PaymentCardType::setReadyFor3DSVersion()
     * @uses PaymentCardType::setAuthenticationExemptionCode()
     * @uses PaymentCardType::setApplePayInd()
     * @uses PaymentCardType::setEffectiveDate()
     * @uses PaymentCardType::setExpireDate()
     * @uses PaymentCardType::setMaskedCardNumber()
     * @uses PaymentCardType::setTokenizedCardNumber()
     * @uses PaymentCardType::setEncryptedCardNumber()
     * @uses PaymentCardType::setExtendPayment()
     * @uses PaymentCardType::setTrack1()
     * @uses PaymentCardType::setTrack2()
     * @uses PaymentCardType::setReturnTokenInd()
     * @uses PaymentCardType::setStoredCredentialTransactionInd()
     * @uses PaymentCardType::setNetworkTransactionReference()
     * @uses PaymentCardType::setApplePayMerchantID()
     * @uses PaymentCardType::setTokenCryptogram()
     * @param \SabrePaymentGateway\StructType\DCCType $dCC
     * @param \SabrePaymentGateway\StructType\T3DS $t3DS
     * @param \SabrePaymentGateway\StructType\CardReader $cardReader
     * @param \SabrePaymentGateway\StructType\CardHolderName $cardHolderName
     * @param \SabrePaymentGateway\StructType\Identifications $identifications
     * @param string $gender
     * @param string $frequentFlyerID
     * @param \SabrePaymentGateway\StructType\CardIssuerName $cardIssuerName
     * @param \SabrePaymentGateway\StructType\AddressType $address
     * @param string[] $emailAddress
     * @param \SabrePaymentGateway\StructType\PhoneType[] $phoneNumber
     * @param string $dOB
     * @param string $sSN
     * @param bool $authenticated
     * @param string $customerType
     * @param \SabrePaymentGateway\StructType\VCL_Info $vCL_Info
     * @param string $applePayCryptogram
     * @param \SabrePaymentGateway\StructType\VirtualCard $virtualCard
     * @param \SabrePaymentGateway\StructType\LoyaltyMembershipDetailType $loyaltyMemberDetail
     * @param string $cardType
     * @param string $cardCode
     * @param string $inputCardCode
     * @param string $cardNumber
     * @param string $issueNumber
     * @param string $pIN
     * @param string $cardSecurityCode
     * @param bool $t3DS_Ind
     * @param bool $trigger3DS
     * @param bool $bypass3DS
     * @param string $readyFor3DSVersion
     * @param string $authenticationExemptionCode
     * @param bool $applePayInd
     * @param string $effectiveDate
     * @param string $expireDate
     * @param string $maskedCardNumber
     * @param string $tokenizedCardNumber
     * @param string $encryptedCardNumber
     * @param string $extendPayment
     * @param string $track1
     * @param string $track2
     * @param bool $returnTokenInd
     * @param bool $storedCredentialTransactionInd
     * @param string $networkTransactionReference
     * @param string $applePayMerchantID
     * @param string $tokenCryptogram
     */
    public function __construct(\SabrePaymentGateway\StructType\DCCType $dCC = null, \SabrePaymentGateway\StructType\T3DS $t3DS = null, \SabrePaymentGateway\StructType\CardReader $cardReader = null, \SabrePaymentGateway\StructType\CardHolderName $cardHolderName = null, \SabrePaymentGateway\StructType\Identifications $identifications = null, $gender = null, $frequentFlyerID = null, \SabrePaymentGateway\StructType\CardIssuerName $cardIssuerName = null, \SabrePaymentGateway\StructType\AddressType $address = null, array $emailAddress = array(), array $phoneNumber = array(), $dOB = null, $sSN = null, $authenticated = null, $customerType = null, \SabrePaymentGateway\StructType\VCL_Info $vCL_Info = null, $applePayCryptogram = null, \SabrePaymentGateway\StructType\VirtualCard $virtualCard = null, \SabrePaymentGateway\StructType\LoyaltyMembershipDetailType $loyaltyMemberDetail = null, $cardType = null, $cardCode = null, $inputCardCode = null, $cardNumber = null, $issueNumber = null, $pIN = null, $cardSecurityCode = null, $t3DS_Ind = null, $trigger3DS = null, $bypass3DS = null, $readyFor3DSVersion = null, $authenticationExemptionCode = null, $applePayInd = null, $effectiveDate = null, $expireDate = null, $maskedCardNumber = null, $tokenizedCardNumber = null, $encryptedCardNumber = null, $extendPayment = null, $track1 = null, $track2 = null, $returnTokenInd = null, $storedCredentialTransactionInd = null, $networkTransactionReference = null, $applePayMerchantID = null, $tokenCryptogram = null)
    {
        $this
            ->setDCC($dCC)
            ->setT3DS($t3DS)
            ->setCardReader($cardReader)
            ->setCardHolderName($cardHolderName)
            ->setIdentifications($identifications)
            ->setGender($gender)
            ->setFrequentFlyerID($frequentFlyerID)
            ->setCardIssuerName($cardIssuerName)
            ->setAddress($address)
            ->setEmailAddress($emailAddress)
            ->setPhoneNumber($phoneNumber)
            ->setDOB($dOB)
            ->setSSN($sSN)
            ->setAuthenticated($authenticated)
            ->setCustomerType($customerType)
            ->setVCL_Info($vCL_Info)
            ->setApplePayCryptogram($applePayCryptogram)
            ->setVirtualCard($virtualCard)
            ->setLoyaltyMemberDetail($loyaltyMemberDetail)
            ->setCardType($cardType)
            ->setCardCode($cardCode)
            ->setInputCardCode($inputCardCode)
            ->setCardNumber($cardNumber)
            ->setIssueNumber($issueNumber)
            ->setPIN($pIN)
            ->setCardSecurityCode($cardSecurityCode)
            ->setT3DS_Ind($t3DS_Ind)
            ->setTrigger3DS($trigger3DS)
            ->setBypass3DS($bypass3DS)
            ->setReadyFor3DSVersion($readyFor3DSVersion)
            ->setAuthenticationExemptionCode($authenticationExemptionCode)
            ->setApplePayInd($applePayInd)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate)
            ->setMaskedCardNumber($maskedCardNumber)
            ->setTokenizedCardNumber($tokenizedCardNumber)
            ->setEncryptedCardNumber($encryptedCardNumber)
            ->setExtendPayment($extendPayment)
            ->setTrack1($track1)
            ->setTrack2($track2)
            ->setReturnTokenInd($returnTokenInd)
            ->setStoredCredentialTransactionInd($storedCredentialTransactionInd)
            ->setNetworkTransactionReference($networkTransactionReference)
            ->setApplePayMerchantID($applePayMerchantID)
            ->setTokenCryptogram($tokenCryptogram);
    }
    /**
     * Get DCC value
     * @return \SabrePaymentGateway\StructType\DCCType|null
     */
    public function getDCC()
    {
        return $this->DCC;
    }
    /**
     * Set DCC value
     * @param \SabrePaymentGateway\StructType\DCCType $dCC
     * @return \SabrePaymentGateway\StructType\PaymentCardType
     */
    public function setDCC(\SabrePaymentGateway\StructType\DCCType $dCC = null)
    {
        $this->DCC = $dCC;
        return $this;
    }
    /**
     * Get T3DS value
     * @return \SabrePaymentGateway\StructType\T3DS|null
     */
    public function getT3DS()
    {
        return $this->T3DS;
    }
    /**
     * Set T3DS value
     * @param \SabrePaymentGateway\StructType\T3DS $t3DS
     * @return \SabrePaymentGateway\StructType\PaymentCardType
     */
    public function setT3DS(\SabrePaymentGateway\StructType\T3DS $t3DS = null)
    {
        $this->T3DS = $t3DS;
        return $this;
    }
    /**
     * Get CardReader value
     * @return \SabrePaymentGateway\StructType\CardReader|null
     */
    public function getCardReader()
    {
        return $this->CardReader;
    }
    /**
     * Set CardReader value
     * @param \SabrePaymentGateway\StructType\CardReader $cardReader
     * @return \SabrePaymentGateway\StructType\PaymentCardType
     */
    public function setCardReader(\SabrePaymentGateway\StructType\CardReader $cardReader = null)
    {
        $this->CardReader = $cardReader;
        return $this;
    }
    /**
     * Get CardHolderName value
     * @return \SabrePaymentGateway\StructType\CardHolderName|null
     */
    public function getCardHolderName()
    {
        return $this->CardHolderName;
    }
    /**
     * Set CardHolderName value
     * @param \SabrePaymentGateway\StructType\CardHolderName $cardHolderName
     * @return \SabrePaymentGateway\StructType\PaymentCardType
     */
    public function setCardHolderName(\SabrePaymentGateway\StructType\CardHolderName $cardHolderName = null)
    {
        $this->CardHolderName = $cardHolderName;
        return $this;
    }
    /**
     * Get Identifications value
     * @return \SabrePaymentGateway\StructType\Identifications|null
     */
    public function getIdentifications()
    {
        return $this->Identifications;
    }
    /**
     * Set Identifications value
     * @param \SabrePaymentGateway\StructType\Identifications $identifications
     * @return \SabrePaymentGateway\StructType\PaymentCardType
     */
    public function setIdentifications(\SabrePaymentGateway\StructType\Identifications $identifications = null)
    {
        $this->Identifications = $identifications;
        return $this;
    }
    /**
     * Get Gender value
     * @return string|null
     */
    public function getGender()
    {
        return $this->Gender;
    }
    /**
     * Set Gender value
     * @param string $gender
     * @return \SabrePaymentGateway\StructType\PaymentCardType
     */
    public function setGender($gender = null)
    {
        // validation for constraint: string
        if (!is_null($gender) && !is_string($gender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gender, true), gettype($gender)), __LINE__);
        }
        $this->Gender = $gender;
        return $this;
    }
    /**
     * Get FrequentFlyerID value
     * @return string|null
     */
    public function getFrequentFlyerID()
    {
        return $this->FrequentFlyerID;
    }
    /**
     * Set FrequentFlyerID value
     * @param string $frequentFlyerID
     * @return \SabrePaymentGateway\StructType\PaymentCardType
     */
    public function setFrequentFlyerID($frequentFlyerID = null)
    {
        // validation for constraint: string
        if (!is_null($frequentFlyerID) && !is_string($frequentFlyerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frequentFlyerID, true), gettype($frequentFlyerID)), __LINE__);
        }
        $this->FrequentFlyerID = $frequentFlyerID;
        return $this;
    }
    /**
     * Get CardIssuerName value
     * @return \SabrePaymentGateway\StructType\CardIssuerName|null
     */
    public function getCardIssuerName()
    {
        return $this->CardIssuerName;
    }
    /**
     * Set CardIssuerName value
     * @param \SabrePaymentGateway\StructType\CardIssuerName $cardIssuerName
     * @return \SabrePaymentGateway\StructType\PaymentCardType
     */
    public function setCardIssuerName(\SabrePaymentGateway\StructType\CardIssuerName $cardIssuerName = null)
    {
        $this->CardIssuerName = $cardIssuerName;
        return $this;
    }
    /**
     * Get Address value
     * @return \SabrePaymentGateway\StructType\AddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \SabrePaymentGateway\StructType\AddressType $address
     * @return \SabrePaymentGateway\StructType\PaymentCardType
     */
    public function setAddress(\SabrePaymentGateway\StructType\AddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get EmailAddress value
     * @return string[]|null
     */
    public function getEmailAddress()
    {
        return $this->EmailAddress;
    }
    /**
     * This method is responsible for validating the values passed to the setEmailAddress method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmailAddress method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmailAddressForArrayConstraintsFromSetEmailAddress(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentCardTypeEmailAddressItem) {
            // validation for constraint: itemType
            if (!is_string($paymentCardTypeEmailAddressItem)) {
                $invalidValues[] = is_object($paymentCardTypeEmailAddressItem) ? get_class($paymentCardTypeEmailAddressItem) : sprintf('%s(%s)', gettype($paymentCardTypeEmailAddressItem), var_export($paymentCardTypeEmailAddressItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EmailAddress property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EmailAddress value
     * @throws \InvalidArgumentException
     * @param string[] $emailAddress
     * @return \SabrePaymentGateway\StructType\PaymentCardType
     */
    public function setEmailAddress(array $emailAddress = array())
    {
        // validation for constraint: array
        if ('' !== ($emailAddressArrayErrorMessage = self::validateEmailAddressForArrayConstraintsFromSetEmailAddress($emailAddress))) {
            throw new \InvalidArgumentException($emailAddressArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($emailAddress) && count($emailAddress) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($emailAddress)), __LINE__);
        }
        $this->EmailAddress = $emailAddress;
        return $this;
    }
    /**
     * Add item to EmailAddress value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \SabrePaymentGateway\StructType\PaymentCardType
     */
    public function addToEmailAddress($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The EmailAddress property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->EmailAddress) && count($this->EmailAddress) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->EmailAddress)), __LINE__);
        }
        $this->EmailAddress[] = $item;
        return $this;
    }
    /**
     * Get PhoneNumber value
     * @return \SabrePaymentGateway\StructType\PhoneType[]|null
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }
    /**
     * This method is responsible for validating the values passed to the setPhoneNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPhoneNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePhoneNumberForArrayConstraintsFromSetPhoneNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentCardTypePhoneNumberItem) {
            // validation for constraint: itemType
            if (!$paymentCardTypePhoneNumberItem instanceof \SabrePaymentGateway\StructType\PhoneType) {
                $invalidValues[] = is_object($paymentCardTypePhoneNumberItem) ? get_class($paymentCardTypePhoneNumberItem) : sprintf('%s(%s)', gettype($paymentCardTypePhoneNumberItem), var_export($paymentCardTypePhoneNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PhoneNumber property can only contain items of type \SabrePaymentGateway\StructType\PhoneType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PhoneNumber value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\PhoneType[] $phoneNumber
     * @return \SabrePaymentGateway\StructType\PaymentCardType
     */
    public function setPhoneNumber(array $phoneNumber = array())
    {
        // validation for constraint: array
        if ('' !== ($phoneNumberArrayErrorMessage = self::validatePhoneNumberForArrayConstraintsFromSetPhoneNumber($phoneNumber))) {
            throw new \InvalidArgumentException($phoneNumberArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($phoneNumber) && count($phoneNumber) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($phoneNumber)), __LINE__);
        }
        $this->PhoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Add item to PhoneNumber value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\PhoneType $item
     * @return \SabrePaymentGateway\StructType\PaymentCardType
     */
    public function addToPhoneNumber(\SabrePaymentGateway\StructType\PhoneType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SabrePaymentGateway\StructType\PhoneType) {
            throw new \InvalidArgumentException(sprintf('The PhoneNumber property can only contain items of type \SabrePaymentGateway\StructType\PhoneType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->PhoneNumber) && count($this->PhoneNumber) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->PhoneNumber)), __LINE__);
        }
        $this->PhoneNumber[] = $item;
        return $this;
    }
    /**
     * Get DOB value
     * @return string|null
     */
    public function getDOB()
    {
        return $this->DOB;
    }
    /**
     * Set DOB value
     * @param string $dOB
     * @return \SabrePaymentGateway\StructType\PaymentCardType
     */
    public function setDOB($dOB = null)
    {
        // validation for constraint: string
        if (!is_null($dOB) && !is_string($dOB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dOB, true), gettype($dOB)), __LINE__);
        }
        $this->DOB = $dOB;
        return $this;
    }
    /**
     * Get SSN value
     * @return string|null
     */
    public function getSSN()
    {
        return $this->SSN;
    }
    /**
     * Set SSN value
     * @param string $sSN
     * @return \SabrePaymentGateway\StructType\PaymentCardType
     */
    public function setSSN($sSN = null)
    {
        // validation for constraint: string
        if (!is_null($sSN) && !is_string($sSN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sSN, true), gettype($sSN)), __LINE__);
        }
        $this->SSN = $sSN;
        return $this;
    }
    /**
     * Get Authenticated value
     * @return bool|null
     */
    public function getAuthenticated()
    {
        return $this->Authenticated;
    }
    /**
     * Set Authenticated value
     * @param bool $authenticated
     * @return \SabrePaymentGateway\StructType\PaymentCardType
     */
    public function setAuthenticated($authenticated = null)
    {
        // validation for constraint: boolean
        if (!is_null($authenticated) && !is_bool($authenticated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($authenticated, true), gettype($authenticated)), __LINE__);
        }
        $this->Authenticated = $authenticated;
        return $this;
    }
    /**
     * Get CustomerType value
     * @return string|null
     */
    public function getCustomerType()
    {
        return $this->CustomerType;
    }
    /**
     * Set CustomerType value
     * @param string $customerType
     * @return \SabrePaymentGateway\StructType\PaymentCardType
     */
    public function setCustomerType($customerType = null)
    {
        // validation for constraint: string
        if (!is_null($customerType) && !is_string($customerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerType, true), gettype($customerType)), __LINE__);
        }
        $this->CustomerType = $customerType;
        return $this;
    }
    /**
     * Get VCL_Info value
     * @return \SabrePaymentGateway\StructType\VCL_Info|null
     */
    public function getVCL_Info()
    {
        return $this->VCL_Info;
    }
    /**
     * Set VCL_Info value
     * @param \SabrePaymentGateway\StructType\VCL_Info $vCL_Info
     * @return \SabrePaymentGateway\StructType\PaymentCardType
     */
    public function setVCL_Info(\SabrePaymentGateway\StructType\VCL_Info $vCL_Info = null)
    {
        $this->VCL_Info = $vCL_Info;
        return $this;
    }
    /**
     * Get ApplePayCryptogram value
     * @return string|null
     */
    public function getApplePayCryptogram()
    {
        return $this->ApplePayCryptogram;
    }
    /**
     * Set ApplePayCryptogram value
     * @param string $applePayCryptogram
     * @return \SabrePaymentGateway\StructType\PaymentCardType
     */
    public function setApplePayCryptogram($applePayCryptogram = null)
    {
        // validation for constraint: string
        if (!is_null($applePayCryptogram) && !is_string($applePayCryptogram)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applePayCryptogram, true), gettype($applePayCryptogram)), __LINE__);
        }
        $this->ApplePayCryptogram = $applePayCryptogram;
        return $this;
    }
    /**
     * Get VirtualCard value
     * @return \SabrePaymentGateway\StructType\VirtualCard|null
     */
    public function getVirtualCard()
    {
        return $this->VirtualCard;
    }
    /**
     * Set VirtualCard value
     * @param \SabrePaymentGateway\StructType\VirtualCard $virtualCard
     * @return \SabrePaymentGateway\StructType\PaymentCardType
     */
    public function setVirtualCard(\SabrePaymentGateway\StructType\VirtualCard $virtualCard = null)
    {
        $this->VirtualCard = $virtualCard;
        return $this;
    }
    /**
     * Get LoyaltyMemberDetail value
     * @return \SabrePaymentGateway\StructType\LoyaltyMembershipDetailType|null
     */
    public function getLoyaltyMemberDetail()
    {
        return $this->LoyaltyMemberDetail;
    }
    /**
     * Set LoyaltyMemberDetail value
     * @param \SabrePaymentGateway\StructType\LoyaltyMembershipDetailType $loyaltyMemberDetail
     * @return \SabrePaymentGateway\StructType\PaymentCardType
     */
    public function setLoyaltyMemberDetail(\SabrePaymentGateway\StructType\LoyaltyMembershipDetailType $loyaltyMemberDetail = null)
    {
        $this->LoyaltyMemberDetail = $loyaltyMemberDetail;
        return $this;
    }
    /**
     * Get CardType value
     * @return string|null
     */
    public function getCardType()
    {
        return $this->CardType;
    }
    /**
     * Set CardType value
     * @param string $cardType
     * @return \SabrePaymentGateway\StructType\PaymentCardType
     */
    public function setCardType($cardType = null)
    {
        // validation for constraint: string
        if (!is_null($cardType) && !is_string($cardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardType, true), gettype($cardType)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3})
        if (!is_null($cardType) && !preg_match('/[0-9A-Z]{1,3}/', $cardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}', var_export($cardType, true)), __LINE__);
        }
        $this->CardType = $cardType;
        return $this;
    }
    /**
     * Get CardCode value
     * @return string|null
     */
    public function getCardCode()
    {
        return $this->CardCode;
    }
    /**
     * Set CardCode value
     * @param string $cardCode
     * @return \SabrePaymentGateway\StructType\PaymentCardType
     */
    public function setCardCode($cardCode = null)
    {
        // validation for constraint: string
        if (!is_null($cardCode) && !is_string($cardCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardCode, true), gettype($cardCode)), __LINE__);
        }
        $this->CardCode = $cardCode;
        return $this;
    }
    /**
     * Get InputCardCode value
     * @return string|null
     */
    public function getInputCardCode()
    {
        return $this->InputCardCode;
    }
    /**
     * Set InputCardCode value
     * @param string $inputCardCode
     * @return \SabrePaymentGateway\StructType\PaymentCardType
     */
    public function setInputCardCode($inputCardCode = null)
    {
        // validation for constraint: string
        if (!is_null($inputCardCode) && !is_string($inputCardCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inputCardCode, true), gettype($inputCardCode)), __LINE__);
        }
        $this->InputCardCode = $inputCardCode;
        return $this;
    }
    /**
     * Get CardNumber value
     * @return string|null
     */
    public function getCardNumber()
    {
        return $this->CardNumber;
    }
    /**
     * Set CardNumber value
     * @param string $cardNumber
     * @return \SabrePaymentGateway\StructType\PaymentCardType
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        $this->CardNumber = $cardNumber;
        return $this;
    }
    /**
     * Get IssueNumber value
     * @return string|null
     */
    public function getIssueNumber()
    {
        return $this->IssueNumber;
    }
    /**
     * Set IssueNumber value
     * @param string $issueNumber
     * @return \SabrePaymentGateway\StructType\PaymentCardType
     */
    public function setIssueNumber($issueNumber = null)
    {
        // validation for constraint: string
        if (!is_null($issueNumber) && !is_string($issueNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issueNumber, true), gettype($issueNumber)), __LINE__);
        }
        $this->IssueNumber = $issueNumber;
        return $this;
    }
    /**
     * Get PIN value
     * @return string|null
     */
    public function getPIN()
    {
        return $this->PIN;
    }
    /**
     * Set PIN value
     * @param string $pIN
     * @return \SabrePaymentGateway\StructType\PaymentCardType
     */
    public function setPIN($pIN = null)
    {
        // validation for constraint: string
        if (!is_null($pIN) && !is_string($pIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pIN, true), gettype($pIN)), __LINE__);
        }
        $this->PIN = $pIN;
        return $this;
    }
    /**
     * Get CardSecurityCode value
     * @return string|null
     */
    public function getCardSecurityCode()
    {
        return $this->CardSecurityCode;
    }
    /**
     * Set CardSecurityCode value
     * @param string $cardSecurityCode
     * @return \SabrePaymentGateway\StructType\PaymentCardType
     */
    public function setCardSecurityCode($cardSecurityCode = null)
    {
        // validation for constraint: string
        if (!is_null($cardSecurityCode) && !is_string($cardSecurityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardSecurityCode, true), gettype($cardSecurityCode)), __LINE__);
        }
        $this->CardSecurityCode = $cardSecurityCode;
        return $this;
    }
    /**
     * Get T3DS_Ind value
     * @return bool|null
     */
    public function getT3DS_Ind()
    {
        return $this->T3DS_Ind;
    }
    /**
     * Set T3DS_Ind value
     * @param bool $t3DS_Ind
     * @return \SabrePaymentGateway\StructType\PaymentCardType
     */
    public function setT3DS_Ind($t3DS_Ind = null)
    {
        // validation for constraint: boolean
        if (!is_null($t3DS_Ind) && !is_bool($t3DS_Ind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($t3DS_Ind, true), gettype($t3DS_Ind)), __LINE__);
        }
        $this->T3DS_Ind = $t3DS_Ind;
        return $this;
    }
    /**
     * Get Trigger3DS value
     * @return bool|null
     */
    public function getTrigger3DS()
    {
        return $this->Trigger3DS;
    }
    /**
     * Set Trigger3DS value
     * @param bool $trigger3DS
     * @return \SabrePaymentGateway\StructType\PaymentCardType
     */
    public function setTrigger3DS($trigger3DS = null)
    {
        // validation for constraint: boolean
        if (!is_null($trigger3DS) && !is_bool($trigger3DS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($trigger3DS, true), gettype($trigger3DS)), __LINE__);
        }
        $this->Trigger3DS = $trigger3DS;
        return $this;
    }
    /**
     * Get Bypass3DS value
     * @return bool|null
     */
    public function getBypass3DS()
    {
        return $this->Bypass3DS;
    }
    /**
     * Set Bypass3DS value
     * @param bool $bypass3DS
     * @return \SabrePaymentGateway\StructType\PaymentCardType
     */
    public function setBypass3DS($bypass3DS = null)
    {
        // validation for constraint: boolean
        if (!is_null($bypass3DS) && !is_bool($bypass3DS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bypass3DS, true), gettype($bypass3DS)), __LINE__);
        }
        $this->Bypass3DS = $bypass3DS;
        return $this;
    }
    /**
     * Get ReadyFor3DSVersion value
     * @return string|null
     */
    public function getReadyFor3DSVersion()
    {
        return $this->ReadyFor3DSVersion;
    }
    /**
     * Set ReadyFor3DSVersion value
     * @param string $readyFor3DSVersion
     * @return \SabrePaymentGateway\StructType\PaymentCardType
     */
    public function setReadyFor3DSVersion($readyFor3DSVersion = null)
    {
        // validation for constraint: string
        if (!is_null($readyFor3DSVersion) && !is_string($readyFor3DSVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($readyFor3DSVersion, true), gettype($readyFor3DSVersion)), __LINE__);
        }
        $this->ReadyFor3DSVersion = $readyFor3DSVersion;
        return $this;
    }
    /**
     * Get AuthenticationExemptionCode value
     * @return string|null
     */
    public function getAuthenticationExemptionCode()
    {
        return $this->AuthenticationExemptionCode;
    }
    /**
     * Set AuthenticationExemptionCode value
     * @param string $authenticationExemptionCode
     * @return \SabrePaymentGateway\StructType\PaymentCardType
     */
    public function setAuthenticationExemptionCode($authenticationExemptionCode = null)
    {
        // validation for constraint: string
        if (!is_null($authenticationExemptionCode) && !is_string($authenticationExemptionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authenticationExemptionCode, true), gettype($authenticationExemptionCode)), __LINE__);
        }
        $this->AuthenticationExemptionCode = $authenticationExemptionCode;
        return $this;
    }
    /**
     * Get ApplePayInd value
     * @return bool|null
     */
    public function getApplePayInd()
    {
        return $this->ApplePayInd;
    }
    /**
     * Set ApplePayInd value
     * @param bool $applePayInd
     * @return \SabrePaymentGateway\StructType\PaymentCardType
     */
    public function setApplePayInd($applePayInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($applePayInd) && !is_bool($applePayInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($applePayInd, true), gettype($applePayInd)), __LINE__);
        }
        $this->ApplePayInd = $applePayInd;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \SabrePaymentGateway\StructType\PaymentCardType
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \SabrePaymentGateway\StructType\PaymentCardType
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expireDate, true), gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get MaskedCardNumber value
     * @return string|null
     */
    public function getMaskedCardNumber()
    {
        return $this->MaskedCardNumber;
    }
    /**
     * Set MaskedCardNumber value
     * @param string $maskedCardNumber
     * @return \SabrePaymentGateway\StructType\PaymentCardType
     */
    public function setMaskedCardNumber($maskedCardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($maskedCardNumber) && !is_string($maskedCardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maskedCardNumber, true), gettype($maskedCardNumber)), __LINE__);
        }
        $this->MaskedCardNumber = $maskedCardNumber;
        return $this;
    }
    /**
     * Get TokenizedCardNumber value
     * @return string|null
     */
    public function getTokenizedCardNumber()
    {
        return $this->TokenizedCardNumber;
    }
    /**
     * Set TokenizedCardNumber value
     * @param string $tokenizedCardNumber
     * @return \SabrePaymentGateway\StructType\PaymentCardType
     */
    public function setTokenizedCardNumber($tokenizedCardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($tokenizedCardNumber) && !is_string($tokenizedCardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenizedCardNumber, true), gettype($tokenizedCardNumber)), __LINE__);
        }
        $this->TokenizedCardNumber = $tokenizedCardNumber;
        return $this;
    }
    /**
     * Get EncryptedCardNumber value
     * @return string|null
     */
    public function getEncryptedCardNumber()
    {
        return $this->EncryptedCardNumber;
    }
    /**
     * Set EncryptedCardNumber value
     * @param string $encryptedCardNumber
     * @return \SabrePaymentGateway\StructType\PaymentCardType
     */
    public function setEncryptedCardNumber($encryptedCardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($encryptedCardNumber) && !is_string($encryptedCardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($encryptedCardNumber, true), gettype($encryptedCardNumber)), __LINE__);
        }
        $this->EncryptedCardNumber = $encryptedCardNumber;
        return $this;
    }
    /**
     * Get ExtendPayment value
     * @return string|null
     */
    public function getExtendPayment()
    {
        return $this->ExtendPayment;
    }
    /**
     * Set ExtendPayment value
     * @param string $extendPayment
     * @return \SabrePaymentGateway\StructType\PaymentCardType
     */
    public function setExtendPayment($extendPayment = null)
    {
        // validation for constraint: string
        if (!is_null($extendPayment) && !is_string($extendPayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendPayment, true), gettype($extendPayment)), __LINE__);
        }
        $this->ExtendPayment = $extendPayment;
        return $this;
    }
    /**
     * Get Track1 value
     * @return string|null
     */
    public function getTrack1()
    {
        return $this->Track1;
    }
    /**
     * Set Track1 value
     * @param string $track1
     * @return \SabrePaymentGateway\StructType\PaymentCardType
     */
    public function setTrack1($track1 = null)
    {
        // validation for constraint: string
        if (!is_null($track1) && !is_string($track1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($track1, true), gettype($track1)), __LINE__);
        }
        $this->Track1 = $track1;
        return $this;
    }
    /**
     * Get Track2 value
     * @return string|null
     */
    public function getTrack2()
    {
        return $this->Track2;
    }
    /**
     * Set Track2 value
     * @param string $track2
     * @return \SabrePaymentGateway\StructType\PaymentCardType
     */
    public function setTrack2($track2 = null)
    {
        // validation for constraint: string
        if (!is_null($track2) && !is_string($track2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($track2, true), gettype($track2)), __LINE__);
        }
        $this->Track2 = $track2;
        return $this;
    }
    /**
     * Get ReturnTokenInd value
     * @return bool|null
     */
    public function getReturnTokenInd()
    {
        return $this->ReturnTokenInd;
    }
    /**
     * Set ReturnTokenInd value
     * @param bool $returnTokenInd
     * @return \SabrePaymentGateway\StructType\PaymentCardType
     */
    public function setReturnTokenInd($returnTokenInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($returnTokenInd) && !is_bool($returnTokenInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($returnTokenInd, true), gettype($returnTokenInd)), __LINE__);
        }
        $this->ReturnTokenInd = $returnTokenInd;
        return $this;
    }
    /**
     * Get StoredCredentialTransactionInd value
     * @return bool|null
     */
    public function getStoredCredentialTransactionInd()
    {
        return $this->StoredCredentialTransactionInd;
    }
    /**
     * Set StoredCredentialTransactionInd value
     * @param bool $storedCredentialTransactionInd
     * @return \SabrePaymentGateway\StructType\PaymentCardType
     */
    public function setStoredCredentialTransactionInd($storedCredentialTransactionInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($storedCredentialTransactionInd) && !is_bool($storedCredentialTransactionInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($storedCredentialTransactionInd, true), gettype($storedCredentialTransactionInd)), __LINE__);
        }
        $this->StoredCredentialTransactionInd = $storedCredentialTransactionInd;
        return $this;
    }
    /**
     * Get NetworkTransactionReference value
     * @return string|null
     */
    public function getNetworkTransactionReference()
    {
        return $this->NetworkTransactionReference;
    }
    /**
     * Set NetworkTransactionReference value
     * @param string $networkTransactionReference
     * @return \SabrePaymentGateway\StructType\PaymentCardType
     */
    public function setNetworkTransactionReference($networkTransactionReference = null)
    {
        // validation for constraint: string
        if (!is_null($networkTransactionReference) && !is_string($networkTransactionReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($networkTransactionReference, true), gettype($networkTransactionReference)), __LINE__);
        }
        $this->NetworkTransactionReference = $networkTransactionReference;
        return $this;
    }
    /**
     * Get ApplePayMerchantID value
     * @return string|null
     */
    public function getApplePayMerchantID()
    {
        return $this->ApplePayMerchantID;
    }
    /**
     * Set ApplePayMerchantID value
     * @param string $applePayMerchantID
     * @return \SabrePaymentGateway\StructType\PaymentCardType
     */
    public function setApplePayMerchantID($applePayMerchantID = null)
    {
        // validation for constraint: string
        if (!is_null($applePayMerchantID) && !is_string($applePayMerchantID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applePayMerchantID, true), gettype($applePayMerchantID)), __LINE__);
        }
        $this->ApplePayMerchantID = $applePayMerchantID;
        return $this;
    }
    /**
     * Get TokenCryptogram value
     * @return string|null
     */
    public function getTokenCryptogram()
    {
        return $this->TokenCryptogram;
    }
    /**
     * Set TokenCryptogram value
     * @param string $tokenCryptogram
     * @return \SabrePaymentGateway\StructType\PaymentCardType
     */
    public function setTokenCryptogram($tokenCryptogram = null)
    {
        // validation for constraint: string
        if (!is_null($tokenCryptogram) && !is_string($tokenCryptogram)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenCryptogram, true), gettype($tokenCryptogram)), __LINE__);
        }
        $this->TokenCryptogram = $tokenCryptogram;
        return $this;
    }
}
