<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LocalCardDetail StructType
 * @subpackage Structs
 */
class LocalCardDetail extends AbstractStructBase
{
    /**
     * The CardCode
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $CardCode;
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $CardNumber;
    /**
     * The ExpireDate
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ExpireDate;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Description;
    /**
     * Constructor method for LocalCardDetail
     * @uses LocalCardDetail::setCardCode()
     * @uses LocalCardDetail::setCardNumber()
     * @uses LocalCardDetail::setExpireDate()
     * @uses LocalCardDetail::setDescription()
     * @param string $cardCode
     * @param string $cardNumber
     * @param string $expireDate
     * @param string $description
     */
    public function __construct($cardCode = null, $cardNumber = null, $expireDate = null, $description = null)
    {
        $this
            ->setCardCode($cardCode)
            ->setCardNumber($cardNumber)
            ->setExpireDate($expireDate)
            ->setDescription($description);
    }
    /**
     * Get CardCode value
     * @return string
     */
    public function getCardCode()
    {
        return $this->CardCode;
    }
    /**
     * Set CardCode value
     * @param string $cardCode
     * @return \SabrePaymentGateway\StructType\LocalCardDetail
     */
    public function setCardCode($cardCode = null)
    {
        // validation for constraint: string
        if (!is_null($cardCode) && !is_string($cardCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardCode, true), gettype($cardCode)), __LINE__);
        }
        $this->CardCode = $cardCode;
        return $this;
    }
    /**
     * Get CardNumber value
     * @return string
     */
    public function getCardNumber()
    {
        return $this->CardNumber;
    }
    /**
     * Set CardNumber value
     * @param string $cardNumber
     * @return \SabrePaymentGateway\StructType\LocalCardDetail
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        $this->CardNumber = $cardNumber;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \SabrePaymentGateway\StructType\LocalCardDetail
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expireDate, true), gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \SabrePaymentGateway\StructType\LocalCardDetail
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
}
