<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KeyInfoType StructType
 * Meta information extracted from the WSDL
 * - mixed: true
 * @subpackage Structs
 */
class KeyInfoType extends AbstractStructBase
{
    /**
     * The KeyName
     * Meta information extracted from the WSDL
     * - choice: KeyName | KeyValue | RetrievalMethod | X509Data | PGPData | SPKIData | MgmtData |
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 1
     * - ref: ds:KeyName
     * @var string
     */
    public $KeyName;
    /**
     * The KeyValue
     * Meta information extracted from the WSDL
     * - choice: KeyName | KeyValue | RetrievalMethod | X509Data | PGPData | SPKIData | MgmtData |
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 1
     * - ref: ds:KeyValue
     * @var \SabrePaymentGateway\StructType\KeyValueType
     */
    public $KeyValue;
    /**
     * The RetrievalMethod
     * Meta information extracted from the WSDL
     * - choice: KeyName | KeyValue | RetrievalMethod | X509Data | PGPData | SPKIData | MgmtData |
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 1
     * - ref: ds:RetrievalMethod
     * @var \SabrePaymentGateway\StructType\RetrievalMethodType
     */
    public $RetrievalMethod;
    /**
     * The X509Data
     * Meta information extracted from the WSDL
     * - choice: KeyName | KeyValue | RetrievalMethod | X509Data | PGPData | SPKIData | MgmtData |
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 1
     * - ref: ds:X509Data
     * @var \SabrePaymentGateway\StructType\X509DataType
     */
    public $X509Data;
    /**
     * The PGPData
     * Meta information extracted from the WSDL
     * - choice: KeyName | KeyValue | RetrievalMethod | X509Data | PGPData | SPKIData | MgmtData |
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 1
     * - ref: ds:PGPData
     * @var \SabrePaymentGateway\StructType\PGPDataType
     */
    public $PGPData;
    /**
     * The SPKIData
     * Meta information extracted from the WSDL
     * - choice: KeyName | KeyValue | RetrievalMethod | X509Data | PGPData | SPKIData | MgmtData |
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 1
     * - ref: ds:SPKIData
     * @var \SabrePaymentGateway\StructType\SPKIDataType
     */
    public $SPKIData;
    /**
     * The MgmtData
     * Meta information extracted from the WSDL
     * - choice: KeyName | KeyValue | RetrievalMethod | X509Data | PGPData | SPKIData | MgmtData |
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 1
     * - ref: ds:MgmtData
     * @var string
     */
    public $MgmtData;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * Constructor method for KeyInfoType
     * @uses KeyInfoType::setKeyName()
     * @uses KeyInfoType::setKeyValue()
     * @uses KeyInfoType::setRetrievalMethod()
     * @uses KeyInfoType::setX509Data()
     * @uses KeyInfoType::setPGPData()
     * @uses KeyInfoType::setSPKIData()
     * @uses KeyInfoType::setMgmtData()
     * @uses KeyInfoType::setAny()
     * @uses KeyInfoType::setId()
     * @param string $keyName
     * @param \SabrePaymentGateway\StructType\KeyValueType $keyValue
     * @param \SabrePaymentGateway\StructType\RetrievalMethodType $retrievalMethod
     * @param \SabrePaymentGateway\StructType\X509DataType $x509Data
     * @param \SabrePaymentGateway\StructType\PGPDataType $pGPData
     * @param \SabrePaymentGateway\StructType\SPKIDataType $sPKIData
     * @param string $mgmtData
     * @param \DOMDocument $any
     * @param string $id
     */
    public function __construct($keyName = null, \SabrePaymentGateway\StructType\KeyValueType $keyValue = null, \SabrePaymentGateway\StructType\RetrievalMethodType $retrievalMethod = null, \SabrePaymentGateway\StructType\X509DataType $x509Data = null, \SabrePaymentGateway\StructType\PGPDataType $pGPData = null, \SabrePaymentGateway\StructType\SPKIDataType $sPKIData = null, $mgmtData = null, \DOMDocument $any = null, $id = null)
    {
        $this
            ->setKeyName($keyName)
            ->setKeyValue($keyValue)
            ->setRetrievalMethod($retrievalMethod)
            ->setX509Data($x509Data)
            ->setPGPData($pGPData)
            ->setSPKIData($sPKIData)
            ->setMgmtData($mgmtData)
            ->setAny($any)
            ->setId($id);
    }
    /**
     * Get KeyName value
     * @return string|null
     */
    public function getKeyName()
    {
        return isset($this->KeyName) ? $this->KeyName : null;
    }
    /**
     * This method is responsible for validating the value passed to the setKeyName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKeyName method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateKeyNameForChoiceConstraintsFromSetKeyName($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'KeyValue',
            'RetrievalMethod',
            'X509Data',
            'PGPData',
            'SPKIData',
            'MgmtData',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property KeyName can\'t be set as the property %s is already set. Only one property must be set among these properties: KeyName, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set KeyName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $keyName
     * @return \SabrePaymentGateway\StructType\KeyInfoType
     */
    public function setKeyName($keyName = null)
    {
        // validation for constraint: string
        if (!is_null($keyName) && !is_string($keyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($keyName, true), gettype($keyName)), __LINE__);
        }
        // validation for constraint: choice(KeyName, KeyValue, RetrievalMethod, X509Data, PGPData, SPKIData, MgmtData, )
        if ('' !== ($keyNameChoiceErrorMessage = self::validateKeyNameForChoiceConstraintsFromSetKeyName($keyName))) {
            throw new \InvalidArgumentException($keyNameChoiceErrorMessage, __LINE__);
        }
        if (is_null($keyName) || (is_array($keyName) && empty($keyName))) {
            unset($this->KeyName);
        } else {
            $this->KeyName = $keyName;
        }
        return $this;
    }
    /**
     * Get KeyValue value
     * @return \SabrePaymentGateway\StructType\KeyValueType|null
     */
    public function getKeyValue()
    {
        return isset($this->KeyValue) ? $this->KeyValue : null;
    }
    /**
     * This method is responsible for validating the value passed to the setKeyValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKeyValue method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateKeyValueForChoiceConstraintsFromSetKeyValue($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'KeyName',
            'RetrievalMethod',
            'X509Data',
            'PGPData',
            'SPKIData',
            'MgmtData',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property KeyValue can\'t be set as the property %s is already set. Only one property must be set among these properties: KeyValue, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set KeyValue value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\KeyValueType $keyValue
     * @return \SabrePaymentGateway\StructType\KeyInfoType
     */
    public function setKeyValue(\SabrePaymentGateway\StructType\KeyValueType $keyValue = null)
    {
        // validation for constraint: choice(KeyName, KeyValue, RetrievalMethod, X509Data, PGPData, SPKIData, MgmtData, )
        if ('' !== ($keyValueChoiceErrorMessage = self::validateKeyValueForChoiceConstraintsFromSetKeyValue($keyValue))) {
            throw new \InvalidArgumentException($keyValueChoiceErrorMessage, __LINE__);
        }
        if (is_null($keyValue) || (is_array($keyValue) && empty($keyValue))) {
            unset($this->KeyValue);
        } else {
            $this->KeyValue = $keyValue;
        }
        return $this;
    }
    /**
     * Get RetrievalMethod value
     * @return \SabrePaymentGateway\StructType\RetrievalMethodType|null
     */
    public function getRetrievalMethod()
    {
        return isset($this->RetrievalMethod) ? $this->RetrievalMethod : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRetrievalMethod method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRetrievalMethod method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRetrievalMethodForChoiceConstraintsFromSetRetrievalMethod($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'KeyName',
            'KeyValue',
            'X509Data',
            'PGPData',
            'SPKIData',
            'MgmtData',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property RetrievalMethod can\'t be set as the property %s is already set. Only one property must be set among these properties: RetrievalMethod, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set RetrievalMethod value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\RetrievalMethodType $retrievalMethod
     * @return \SabrePaymentGateway\StructType\KeyInfoType
     */
    public function setRetrievalMethod(\SabrePaymentGateway\StructType\RetrievalMethodType $retrievalMethod = null)
    {
        // validation for constraint: choice(KeyName, KeyValue, RetrievalMethod, X509Data, PGPData, SPKIData, MgmtData, )
        if ('' !== ($retrievalMethodChoiceErrorMessage = self::validateRetrievalMethodForChoiceConstraintsFromSetRetrievalMethod($retrievalMethod))) {
            throw new \InvalidArgumentException($retrievalMethodChoiceErrorMessage, __LINE__);
        }
        if (is_null($retrievalMethod) || (is_array($retrievalMethod) && empty($retrievalMethod))) {
            unset($this->RetrievalMethod);
        } else {
            $this->RetrievalMethod = $retrievalMethod;
        }
        return $this;
    }
    /**
     * Get X509Data value
     * @return \SabrePaymentGateway\StructType\X509DataType|null
     */
    public function getX509Data()
    {
        return isset($this->X509Data) ? $this->X509Data : null;
    }
    /**
     * This method is responsible for validating the value passed to the setX509Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setX509Data method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateX509DataForChoiceConstraintsFromSetX509Data($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'KeyName',
            'KeyValue',
            'RetrievalMethod',
            'PGPData',
            'SPKIData',
            'MgmtData',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property X509Data can\'t be set as the property %s is already set. Only one property must be set among these properties: X509Data, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set X509Data value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\X509DataType $x509Data
     * @return \SabrePaymentGateway\StructType\KeyInfoType
     */
    public function setX509Data(\SabrePaymentGateway\StructType\X509DataType $x509Data = null)
    {
        // validation for constraint: choice(KeyName, KeyValue, RetrievalMethod, X509Data, PGPData, SPKIData, MgmtData, )
        if ('' !== ($x509DataChoiceErrorMessage = self::validateX509DataForChoiceConstraintsFromSetX509Data($x509Data))) {
            throw new \InvalidArgumentException($x509DataChoiceErrorMessage, __LINE__);
        }
        if (is_null($x509Data) || (is_array($x509Data) && empty($x509Data))) {
            unset($this->X509Data);
        } else {
            $this->X509Data = $x509Data;
        }
        return $this;
    }
    /**
     * Get PGPData value
     * @return \SabrePaymentGateway\StructType\PGPDataType|null
     */
    public function getPGPData()
    {
        return isset($this->PGPData) ? $this->PGPData : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPGPData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPGPData method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePGPDataForChoiceConstraintsFromSetPGPData($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'KeyName',
            'KeyValue',
            'RetrievalMethod',
            'X509Data',
            'SPKIData',
            'MgmtData',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PGPData can\'t be set as the property %s is already set. Only one property must be set among these properties: PGPData, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PGPData value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\PGPDataType $pGPData
     * @return \SabrePaymentGateway\StructType\KeyInfoType
     */
    public function setPGPData(\SabrePaymentGateway\StructType\PGPDataType $pGPData = null)
    {
        // validation for constraint: choice(KeyName, KeyValue, RetrievalMethod, X509Data, PGPData, SPKIData, MgmtData, )
        if ('' !== ($pGPDataChoiceErrorMessage = self::validatePGPDataForChoiceConstraintsFromSetPGPData($pGPData))) {
            throw new \InvalidArgumentException($pGPDataChoiceErrorMessage, __LINE__);
        }
        if (is_null($pGPData) || (is_array($pGPData) && empty($pGPData))) {
            unset($this->PGPData);
        } else {
            $this->PGPData = $pGPData;
        }
        return $this;
    }
    /**
     * Get SPKIData value
     * @return \SabrePaymentGateway\StructType\SPKIDataType|null
     */
    public function getSPKIData()
    {
        return isset($this->SPKIData) ? $this->SPKIData : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSPKIData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSPKIData method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSPKIDataForChoiceConstraintsFromSetSPKIData($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'KeyName',
            'KeyValue',
            'RetrievalMethod',
            'X509Data',
            'PGPData',
            'MgmtData',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property SPKIData can\'t be set as the property %s is already set. Only one property must be set among these properties: SPKIData, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set SPKIData value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\SPKIDataType $sPKIData
     * @return \SabrePaymentGateway\StructType\KeyInfoType
     */
    public function setSPKIData(\SabrePaymentGateway\StructType\SPKIDataType $sPKIData = null)
    {
        // validation for constraint: choice(KeyName, KeyValue, RetrievalMethod, X509Data, PGPData, SPKIData, MgmtData, )
        if ('' !== ($sPKIDataChoiceErrorMessage = self::validateSPKIDataForChoiceConstraintsFromSetSPKIData($sPKIData))) {
            throw new \InvalidArgumentException($sPKIDataChoiceErrorMessage, __LINE__);
        }
        if (is_null($sPKIData) || (is_array($sPKIData) && empty($sPKIData))) {
            unset($this->SPKIData);
        } else {
            $this->SPKIData = $sPKIData;
        }
        return $this;
    }
    /**
     * Get MgmtData value
     * @return string|null
     */
    public function getMgmtData()
    {
        return isset($this->MgmtData) ? $this->MgmtData : null;
    }
    /**
     * This method is responsible for validating the value passed to the setMgmtData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMgmtData method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateMgmtDataForChoiceConstraintsFromSetMgmtData($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'KeyName',
            'KeyValue',
            'RetrievalMethod',
            'X509Data',
            'PGPData',
            'SPKIData',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property MgmtData can\'t be set as the property %s is already set. Only one property must be set among these properties: MgmtData, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set MgmtData value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $mgmtData
     * @return \SabrePaymentGateway\StructType\KeyInfoType
     */
    public function setMgmtData($mgmtData = null)
    {
        // validation for constraint: string
        if (!is_null($mgmtData) && !is_string($mgmtData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mgmtData, true), gettype($mgmtData)), __LINE__);
        }
        // validation for constraint: choice(KeyName, KeyValue, RetrievalMethod, X509Data, PGPData, SPKIData, MgmtData, )
        if ('' !== ($mgmtDataChoiceErrorMessage = self::validateMgmtDataForChoiceConstraintsFromSetMgmtData($mgmtData))) {
            throw new \InvalidArgumentException($mgmtDataChoiceErrorMessage, __LINE__);
        }
        if (is_null($mgmtData) || (is_array($mgmtData) && empty($mgmtData))) {
            unset($this->MgmtData);
        } else {
            $this->MgmtData = $mgmtData;
        }
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \SabrePaymentGateway\StructType\KeyInfoType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \SabrePaymentGateway\StructType\KeyInfoType
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
}
