<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetBINResult StructType
 * @subpackage Structs
 */
class GetBINResult extends AbstractStructBase
{
    /**
     * The ResponseCode
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ResponseCode;
    /**
     * The CardCode
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $CardCode;
    /**
     * The CardBIN
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $CardBIN;
    /**
     * The Description
     * @var string
     */
    public $Description;
    /**
     * Constructor method for GetBINResult
     * @uses GetBINResult::setResponseCode()
     * @uses GetBINResult::setCardCode()
     * @uses GetBINResult::setCardBIN()
     * @uses GetBINResult::setDescription()
     * @param string $responseCode
     * @param string $cardCode
     * @param string $cardBIN
     * @param string $description
     */
    public function __construct($responseCode = null, $cardCode = null, $cardBIN = null, $description = null)
    {
        $this
            ->setResponseCode($responseCode)
            ->setCardCode($cardCode)
            ->setCardBIN($cardBIN)
            ->setDescription($description);
    }
    /**
     * Get ResponseCode value
     * @return string
     */
    public function getResponseCode()
    {
        return $this->ResponseCode;
    }
    /**
     * Set ResponseCode value
     * @param string $responseCode
     * @return \SabrePaymentGateway\StructType\GetBINResult
     */
    public function setResponseCode($responseCode = null)
    {
        // validation for constraint: string
        if (!is_null($responseCode) && !is_string($responseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseCode, true), gettype($responseCode)), __LINE__);
        }
        $this->ResponseCode = $responseCode;
        return $this;
    }
    /**
     * Get CardCode value
     * @return string
     */
    public function getCardCode()
    {
        return $this->CardCode;
    }
    /**
     * Set CardCode value
     * @param string $cardCode
     * @return \SabrePaymentGateway\StructType\GetBINResult
     */
    public function setCardCode($cardCode = null)
    {
        // validation for constraint: string
        if (!is_null($cardCode) && !is_string($cardCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardCode, true), gettype($cardCode)), __LINE__);
        }
        $this->CardCode = $cardCode;
        return $this;
    }
    /**
     * Get CardBIN value
     * @return string
     */
    public function getCardBIN()
    {
        return $this->CardBIN;
    }
    /**
     * Set CardBIN value
     * @param string $cardBIN
     * @return \SabrePaymentGateway\StructType\GetBINResult
     */
    public function setCardBIN($cardBIN = null)
    {
        // validation for constraint: string
        if (!is_null($cardBIN) && !is_string($cardBIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardBIN, true), gettype($cardBIN)), __LINE__);
        }
        $this->CardBIN = $cardBIN;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \SabrePaymentGateway\StructType\GetBINResult
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
}
