<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FOPType StructType
 * @subpackage Structs
 */
class FOPType extends AbstractStructBase
{
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Type;
    /**
     * The FOP_Code
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $FOP_Code;
    /**
     * The FOP_Subcode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $FOP_Subcode;
    /**
     * The AdditionalInfo
     * @var string
     */
    public $AdditionalInfo;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Description;
    /**
     * The IssuerID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $IssuerID;
    /**
     * The IssuerName
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $IssuerName;
    /**
     * Constructor method for FOPType
     * @uses FOPType::setType()
     * @uses FOPType::setFOP_Code()
     * @uses FOPType::setFOP_Subcode()
     * @uses FOPType::setAdditionalInfo()
     * @uses FOPType::setDescription()
     * @uses FOPType::setIssuerID()
     * @uses FOPType::setIssuerName()
     * @param string $type
     * @param string $fOP_Code
     * @param string $fOP_Subcode
     * @param string $additionalInfo
     * @param string $description
     * @param string $issuerID
     * @param string $issuerName
     */
    public function __construct($type = null, $fOP_Code = null, $fOP_Subcode = null, $additionalInfo = null, $description = null, $issuerID = null, $issuerName = null)
    {
        $this
            ->setType($type)
            ->setFOP_Code($fOP_Code)
            ->setFOP_Subcode($fOP_Subcode)
            ->setAdditionalInfo($additionalInfo)
            ->setDescription($description)
            ->setIssuerID($issuerID)
            ->setIssuerName($issuerName);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \SabrePaymentGateway\StructType\FOPType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get FOP_Code value
     * @return string
     */
    public function getFOP_Code()
    {
        return $this->FOP_Code;
    }
    /**
     * Set FOP_Code value
     * @param string $fOP_Code
     * @return \SabrePaymentGateway\StructType\FOPType
     */
    public function setFOP_Code($fOP_Code = null)
    {
        // validation for constraint: string
        if (!is_null($fOP_Code) && !is_string($fOP_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fOP_Code, true), gettype($fOP_Code)), __LINE__);
        }
        $this->FOP_Code = $fOP_Code;
        return $this;
    }
    /**
     * Get FOP_Subcode value
     * @return string|null
     */
    public function getFOP_Subcode()
    {
        return $this->FOP_Subcode;
    }
    /**
     * Set FOP_Subcode value
     * @param string $fOP_Subcode
     * @return \SabrePaymentGateway\StructType\FOPType
     */
    public function setFOP_Subcode($fOP_Subcode = null)
    {
        // validation for constraint: string
        if (!is_null($fOP_Subcode) && !is_string($fOP_Subcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fOP_Subcode, true), gettype($fOP_Subcode)), __LINE__);
        }
        $this->FOP_Subcode = $fOP_Subcode;
        return $this;
    }
    /**
     * Get AdditionalInfo value
     * @return string|null
     */
    public function getAdditionalInfo()
    {
        return $this->AdditionalInfo;
    }
    /**
     * Set AdditionalInfo value
     * @param string $additionalInfo
     * @return \SabrePaymentGateway\StructType\FOPType
     */
    public function setAdditionalInfo($additionalInfo = null)
    {
        // validation for constraint: string
        if (!is_null($additionalInfo) && !is_string($additionalInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalInfo, true), gettype($additionalInfo)), __LINE__);
        }
        $this->AdditionalInfo = $additionalInfo;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \SabrePaymentGateway\StructType\FOPType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get IssuerID value
     * @return string|null
     */
    public function getIssuerID()
    {
        return $this->IssuerID;
    }
    /**
     * Set IssuerID value
     * @param string $issuerID
     * @return \SabrePaymentGateway\StructType\FOPType
     */
    public function setIssuerID($issuerID = null)
    {
        // validation for constraint: string
        if (!is_null($issuerID) && !is_string($issuerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issuerID, true), gettype($issuerID)), __LINE__);
        }
        $this->IssuerID = $issuerID;
        return $this;
    }
    /**
     * Get IssuerName value
     * @return string|null
     */
    public function getIssuerName()
    {
        return $this->IssuerName;
    }
    /**
     * Set IssuerName value
     * @param string $issuerName
     * @return \SabrePaymentGateway\StructType\FOPType
     */
    public function setIssuerName($issuerName = null)
    {
        // validation for constraint: string
        if (!is_null($issuerName) && !is_string($issuerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issuerName, true), gettype($issuerName)), __LINE__);
        }
        $this->IssuerName = $issuerName;
        return $this;
    }
}
