<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Envelope StructType
 * Meta information extracted from the WSDL
 * - type: tns:Envelope
 * @subpackage Structs
 */
class Envelope extends AbstractStructBase
{
    /**
     * The Header
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: tns:Header
     * @var \SabrePaymentGateway\StructType\Header[]
     */
    public $Header;
    /**
     * The Body
     * Meta information extracted from the WSDL
     * - ref: tns:Body
     * @var \SabrePaymentGateway\StructType\Body
     */
    public $Body;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for Envelope
     * @uses Envelope::setHeader()
     * @uses Envelope::setBody()
     * @uses Envelope::setAny()
     * @param \SabrePaymentGateway\StructType\Header[] $header
     * @param \SabrePaymentGateway\StructType\Body $body
     * @param \DOMDocument $any
     */
    public function __construct(array $header = array(), \SabrePaymentGateway\StructType\Body $body = null, \DOMDocument $any = null)
    {
        $this
            ->setHeader($header)
            ->setBody($body)
            ->setAny($any);
    }
    /**
     * Get Header value
     * @return \SabrePaymentGateway\StructType\Header[]|null
     */
    public function getHeader()
    {
        return $this->Header;
    }
    /**
     * This method is responsible for validating the values passed to the setHeader method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHeader method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHeaderForArrayConstraintsFromSetHeader(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $envelopeHeaderItem) {
            // validation for constraint: itemType
            if (!$envelopeHeaderItem instanceof \SabrePaymentGateway\StructType\Header) {
                $invalidValues[] = is_object($envelopeHeaderItem) ? get_class($envelopeHeaderItem) : sprintf('%s(%s)', gettype($envelopeHeaderItem), var_export($envelopeHeaderItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Header property can only contain items of type \SabrePaymentGateway\StructType\Header, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Header value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\Header[] $header
     * @return \SabrePaymentGateway\StructType\Envelope
     */
    public function setHeader(array $header = array())
    {
        // validation for constraint: array
        if ('' !== ($headerArrayErrorMessage = self::validateHeaderForArrayConstraintsFromSetHeader($header))) {
            throw new \InvalidArgumentException($headerArrayErrorMessage, __LINE__);
        }
        $this->Header = $header;
        return $this;
    }
    /**
     * Add item to Header value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\Header $item
     * @return \SabrePaymentGateway\StructType\Envelope
     */
    public function addToHeader(\SabrePaymentGateway\StructType\Header $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SabrePaymentGateway\StructType\Header) {
            throw new \InvalidArgumentException(sprintf('The Header property can only contain items of type \SabrePaymentGateway\StructType\Header, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Header[] = $item;
        return $this;
    }
    /**
     * Get Body value
     * @return \SabrePaymentGateway\StructType\Body|null
     */
    public function getBody()
    {
        return $this->Body;
    }
    /**
     * Set Body value
     * @param \SabrePaymentGateway\StructType\Body $body
     * @return \SabrePaymentGateway\StructType\Envelope
     */
    public function setBody(\SabrePaymentGateway\StructType\Body $body = null)
    {
        $this->Body = $body;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \SabrePaymentGateway\StructType\Envelope
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
}
