<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CurrencyAmountType StructType
 * Meta information extracted from the WSDL
 * - documentation: Provides a monetary amount and the code of the currency in which this amount is expressed.
 * @subpackage Structs
 */
class CurrencyAmountType extends AbstractStructBase
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - type: Money
     * - use: optional
     * @var float
     */
    public $Amount;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - documentation: 3 alpha ISO 4217
     * - type: xs:string
     * - use: optional
     * @var string
     */
    public $CurrencyCode;
    /**
     * The NumericCurrencyCode
     * Meta information extracted from the WSDL
     * - documentation: 3 numeric ISO 4217
     * - type: xs:string
     * - use: optional
     * @var string
     */
    public $NumericCurrencyCode;
    /**
     * The DecimalPlaces
     * Meta information extracted from the WSDL
     * - documentation: Indicates the number of decimal places for a particular currency. This is equivalent to the ISO 4217 standard "minor unit".
     * - type: xs:string
     * - use: optional
     * @var string
     */
    public $DecimalPlaces;
    /**
     * The ExchangeRate
     * Meta information extracted from the WSDL
     * - documentation: Rate of exchange when CurrencyCode is different than Account currency.
     * - type: xs:double
     * - use: optional
     * @var float
     */
    public $ExchangeRate;
    /**
     * Constructor method for CurrencyAmountType
     * @uses CurrencyAmountType::setAmount()
     * @uses CurrencyAmountType::setCurrencyCode()
     * @uses CurrencyAmountType::setNumericCurrencyCode()
     * @uses CurrencyAmountType::setDecimalPlaces()
     * @uses CurrencyAmountType::setExchangeRate()
     * @param float $amount
     * @param string $currencyCode
     * @param string $numericCurrencyCode
     * @param string $decimalPlaces
     * @param float $exchangeRate
     */
    public function __construct($amount = null, $currencyCode = null, $numericCurrencyCode = null, $decimalPlaces = null, $exchangeRate = null)
    {
        $this
            ->setAmount($amount)
            ->setCurrencyCode($currencyCode)
            ->setNumericCurrencyCode($numericCurrencyCode)
            ->setDecimalPlaces($decimalPlaces)
            ->setExchangeRate($exchangeRate);
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \SabrePaymentGateway\StructType\CurrencyAmountType
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($amount) && mb_strlen(mb_substr($amount, false !== mb_strpos($amount, '.') ? mb_strpos($amount, '.') + 1 : mb_strlen($amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($amount, true), mb_strlen(mb_substr($amount, mb_strpos($amount, '.') + 1))), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \SabrePaymentGateway\StructType\CurrencyAmountType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get NumericCurrencyCode value
     * @return string|null
     */
    public function getNumericCurrencyCode()
    {
        return $this->NumericCurrencyCode;
    }
    /**
     * Set NumericCurrencyCode value
     * @param string $numericCurrencyCode
     * @return \SabrePaymentGateway\StructType\CurrencyAmountType
     */
    public function setNumericCurrencyCode($numericCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($numericCurrencyCode) && !is_string($numericCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numericCurrencyCode, true), gettype($numericCurrencyCode)), __LINE__);
        }
        $this->NumericCurrencyCode = $numericCurrencyCode;
        return $this;
    }
    /**
     * Get DecimalPlaces value
     * @return string|null
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param string $decimalPlaces
     * @return \SabrePaymentGateway\StructType\CurrencyAmountType
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        // validation for constraint: string
        if (!is_null($decimalPlaces) && !is_string($decimalPlaces)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($decimalPlaces, true), gettype($decimalPlaces)), __LINE__);
        }
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
    /**
     * Get ExchangeRate value
     * @return float|null
     */
    public function getExchangeRate()
    {
        return $this->ExchangeRate;
    }
    /**
     * Set ExchangeRate value
     * @param float $exchangeRate
     * @return \SabrePaymentGateway\StructType\CurrencyAmountType
     */
    public function setExchangeRate($exchangeRate = null)
    {
        // validation for constraint: float
        if (!is_null($exchangeRate) && !(is_float($exchangeRate) || is_numeric($exchangeRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exchangeRate, true), gettype($exchangeRate)), __LINE__);
        }
        $this->ExchangeRate = $exchangeRate;
        return $this;
    }
}
