<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelAuthResultType StructType
 * @subpackage Structs
 */
class CancelAuthResultType extends AbstractStructBase
{
    /**
     * The ResponseCode
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ResponseCode;
    /**
     * The CancelAuthAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\CurrencyAmountType
     */
    public $CancelAuthAmount;
    /**
     * The CancelAuthRemarks
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\RemarksType
     */
    public $CancelAuthRemarks;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Description;
    /**
     * The Remarks
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Remarks;
    /**
     * The SupplierID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SupplierID;
    /**
     * The SupplierTransID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SupplierTransID;
    /**
     * The SupplierResponseCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SupplierResponseCode;
    /**
     * The ApprovalCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ApprovalCode;
    /**
     * Constructor method for CancelAuthResultType
     * @uses CancelAuthResultType::setResponseCode()
     * @uses CancelAuthResultType::setCancelAuthAmount()
     * @uses CancelAuthResultType::setCancelAuthRemarks()
     * @uses CancelAuthResultType::setDescription()
     * @uses CancelAuthResultType::setRemarks()
     * @uses CancelAuthResultType::setSupplierID()
     * @uses CancelAuthResultType::setSupplierTransID()
     * @uses CancelAuthResultType::setSupplierResponseCode()
     * @uses CancelAuthResultType::setApprovalCode()
     * @param string $responseCode
     * @param \SabrePaymentGateway\StructType\CurrencyAmountType $cancelAuthAmount
     * @param \SabrePaymentGateway\StructType\RemarksType $cancelAuthRemarks
     * @param string $description
     * @param string $remarks
     * @param string $supplierID
     * @param string $supplierTransID
     * @param string $supplierResponseCode
     * @param string $approvalCode
     */
    public function __construct($responseCode = null, \SabrePaymentGateway\StructType\CurrencyAmountType $cancelAuthAmount = null, \SabrePaymentGateway\StructType\RemarksType $cancelAuthRemarks = null, $description = null, $remarks = null, $supplierID = null, $supplierTransID = null, $supplierResponseCode = null, $approvalCode = null)
    {
        $this
            ->setResponseCode($responseCode)
            ->setCancelAuthAmount($cancelAuthAmount)
            ->setCancelAuthRemarks($cancelAuthRemarks)
            ->setDescription($description)
            ->setRemarks($remarks)
            ->setSupplierID($supplierID)
            ->setSupplierTransID($supplierTransID)
            ->setSupplierResponseCode($supplierResponseCode)
            ->setApprovalCode($approvalCode);
    }
    /**
     * Get ResponseCode value
     * @return string
     */
    public function getResponseCode()
    {
        return $this->ResponseCode;
    }
    /**
     * Set ResponseCode value
     * @param string $responseCode
     * @return \SabrePaymentGateway\StructType\CancelAuthResultType
     */
    public function setResponseCode($responseCode = null)
    {
        // validation for constraint: string
        if (!is_null($responseCode) && !is_string($responseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseCode, true), gettype($responseCode)), __LINE__);
        }
        $this->ResponseCode = $responseCode;
        return $this;
    }
    /**
     * Get CancelAuthAmount value
     * @return \SabrePaymentGateway\StructType\CurrencyAmountType|null
     */
    public function getCancelAuthAmount()
    {
        return $this->CancelAuthAmount;
    }
    /**
     * Set CancelAuthAmount value
     * @param \SabrePaymentGateway\StructType\CurrencyAmountType $cancelAuthAmount
     * @return \SabrePaymentGateway\StructType\CancelAuthResultType
     */
    public function setCancelAuthAmount(\SabrePaymentGateway\StructType\CurrencyAmountType $cancelAuthAmount = null)
    {
        $this->CancelAuthAmount = $cancelAuthAmount;
        return $this;
    }
    /**
     * Get CancelAuthRemarks value
     * @return \SabrePaymentGateway\StructType\RemarksType|null
     */
    public function getCancelAuthRemarks()
    {
        return $this->CancelAuthRemarks;
    }
    /**
     * Set CancelAuthRemarks value
     * @param \SabrePaymentGateway\StructType\RemarksType $cancelAuthRemarks
     * @return \SabrePaymentGateway\StructType\CancelAuthResultType
     */
    public function setCancelAuthRemarks(\SabrePaymentGateway\StructType\RemarksType $cancelAuthRemarks = null)
    {
        $this->CancelAuthRemarks = $cancelAuthRemarks;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \SabrePaymentGateway\StructType\CancelAuthResultType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Remarks value
     * @return string|null
     */
    public function getRemarks()
    {
        return $this->Remarks;
    }
    /**
     * Set Remarks value
     * @param string $remarks
     * @return \SabrePaymentGateway\StructType\CancelAuthResultType
     */
    public function setRemarks($remarks = null)
    {
        // validation for constraint: string
        if (!is_null($remarks) && !is_string($remarks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remarks, true), gettype($remarks)), __LINE__);
        }
        $this->Remarks = $remarks;
        return $this;
    }
    /**
     * Get SupplierID value
     * @return string|null
     */
    public function getSupplierID()
    {
        return $this->SupplierID;
    }
    /**
     * Set SupplierID value
     * @param string $supplierID
     * @return \SabrePaymentGateway\StructType\CancelAuthResultType
     */
    public function setSupplierID($supplierID = null)
    {
        // validation for constraint: string
        if (!is_null($supplierID) && !is_string($supplierID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierID, true), gettype($supplierID)), __LINE__);
        }
        $this->SupplierID = $supplierID;
        return $this;
    }
    /**
     * Get SupplierTransID value
     * @return string|null
     */
    public function getSupplierTransID()
    {
        return $this->SupplierTransID;
    }
    /**
     * Set SupplierTransID value
     * @param string $supplierTransID
     * @return \SabrePaymentGateway\StructType\CancelAuthResultType
     */
    public function setSupplierTransID($supplierTransID = null)
    {
        // validation for constraint: string
        if (!is_null($supplierTransID) && !is_string($supplierTransID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierTransID, true), gettype($supplierTransID)), __LINE__);
        }
        $this->SupplierTransID = $supplierTransID;
        return $this;
    }
    /**
     * Get SupplierResponseCode value
     * @return string|null
     */
    public function getSupplierResponseCode()
    {
        return $this->SupplierResponseCode;
    }
    /**
     * Set SupplierResponseCode value
     * @param string $supplierResponseCode
     * @return \SabrePaymentGateway\StructType\CancelAuthResultType
     */
    public function setSupplierResponseCode($supplierResponseCode = null)
    {
        // validation for constraint: string
        if (!is_null($supplierResponseCode) && !is_string($supplierResponseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierResponseCode, true), gettype($supplierResponseCode)), __LINE__);
        }
        $this->SupplierResponseCode = $supplierResponseCode;
        return $this;
    }
    /**
     * Get ApprovalCode value
     * @return string|null
     */
    public function getApprovalCode()
    {
        return $this->ApprovalCode;
    }
    /**
     * Set ApprovalCode value
     * @param string $approvalCode
     * @return \SabrePaymentGateway\StructType\CancelAuthResultType
     */
    public function setApprovalCode($approvalCode = null)
    {
        // validation for constraint: string
        if (!is_null($approvalCode) && !is_string($approvalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($approvalCode, true), gettype($approvalCode)), __LINE__);
        }
        $this->ApprovalCode = $approvalCode;
        return $this;
    }
}
