<?php

namespace WSQuickShine\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EliminarIVAResponse StructType
 * @package WSQuickShine
 * @subpackage Structs
 */
class WSQuickShineEliminarIVAResponse extends AbstractStructBase
{
    /**
     * The EliminarIVAResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EliminarIVAResult;
    /**
     * Constructor method for EliminarIVAResponse
     * @uses WSQuickShineEliminarIVAResponse::setEliminarIVAResult()
     * @param string $eliminarIVAResult
     */
    public function __construct($eliminarIVAResult = null)
    {
        $this
            ->setEliminarIVAResult($eliminarIVAResult);
    }
    /**
     * Get EliminarIVAResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEliminarIVAResult()
    {
        return isset($this->EliminarIVAResult) ? $this->EliminarIVAResult : null;
    }
    /**
     * Set EliminarIVAResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eliminarIVAResult
     * @return \WSQuickShine\StructType\WSQuickShineEliminarIVAResponse
     */
    public function setEliminarIVAResult($eliminarIVAResult = null)
    {
        // validation for constraint: string
        if (!is_null($eliminarIVAResult) && !is_string($eliminarIVAResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eliminarIVAResult, true), gettype($eliminarIVAResult)), __LINE__);
        }
        if (is_null($eliminarIVAResult) || (is_array($eliminarIVAResult) && empty($eliminarIVAResult))) {
            unset($this->EliminarIVAResult);
        } else {
            $this->EliminarIVAResult = $eliminarIVAResult;
        }
        return $this;
    }
}
