<?php

namespace WSQuickShine\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Valida ServiceType
 * @package WSQuickShine
 * @subpackage Services
 */
class WSQuickShineValida extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ValidaToken
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineValidaToken $parameters
     * @return \WSQuickShine\StructType\WSQuickShineValidaTokenResponse|bool
     */
    public function ValidaToken(\WSQuickShine\StructType\WSQuickShineValidaToken $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ValidaToken($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \WSQuickShine\StructType\WSQuickShineValidaTokenResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
