<?php

namespace WSQuickShine\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Iniciar ServiceType
 * @package WSQuickShine
 * @subpackage Services
 */
class WSQuickShineIniciar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named IniciarSesion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineIniciarSesion $parameters
     * @return \WSQuickShine\StructType\WSQuickShineIniciarSesionResponse|bool
     */
    public function IniciarSesion(\WSQuickShine\StructType\WSQuickShineIniciarSesion $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IniciarSesion($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \WSQuickShine\StructType\WSQuickShineIniciarSesionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
