<?php

namespace WSQuickShine\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Estatus ServiceType
 * @package WSQuickShine
 * @subpackage Services
 */
class WSQuickShineEstatus extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named EstatusCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineEstatusCliente $parameters
     * @return \WSQuickShine\StructType\WSQuickShineEstatusClienteResponse|bool
     */
    public function EstatusCliente(\WSQuickShine\StructType\WSQuickShineEstatusCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EstatusCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EstatusProducto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineEstatusProducto $parameters
     * @return \WSQuickShine\StructType\WSQuickShineEstatusProductoResponse|bool
     */
    public function EstatusProducto(\WSQuickShine\StructType\WSQuickShineEstatusProducto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EstatusProducto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EstatusFactura
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineEstatusFactura $parameters
     * @return \WSQuickShine\StructType\WSQuickShineEstatusFacturaResponse|bool
     */
    public function EstatusFactura(\WSQuickShine\StructType\WSQuickShineEstatusFactura $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EstatusFactura($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EstatusNotaCreditoCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineEstatusNotaCreditoCliente $parameters
     * @return \WSQuickShine\StructType\WSQuickShineEstatusNotaCreditoClienteResponse|bool
     */
    public function EstatusNotaCreditoCliente(\WSQuickShine\StructType\WSQuickShineEstatusNotaCreditoCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EstatusNotaCreditoCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EstatusCobranzaCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineEstatusCobranzaCliente $parameters
     * @return \WSQuickShine\StructType\WSQuickShineEstatusCobranzaClienteResponse|bool
     */
    public function EstatusCobranzaCliente(\WSQuickShine\StructType\WSQuickShineEstatusCobranzaCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EstatusCobranzaCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \WSQuickShine\StructType\WSQuickShineEstatusClienteResponse|\WSQuickShine\StructType\WSQuickShineEstatusCobranzaClienteResponse|\WSQuickShine\StructType\WSQuickShineEstatusFacturaResponse|\WSQuickShine\StructType\WSQuickShineEstatusNotaCreditoClienteResponse|\WSQuickShine\StructType\WSQuickShineEstatusProductoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
