<?php

namespace WSQuickShine\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Encriptar ServiceType
 * @package WSQuickShine
 * @subpackage Services
 */
class WSQuickShineEncriptar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named EncriptarSHA256
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineEncriptarSHA256 $parameters
     * @return \WSQuickShine\StructType\WSQuickShineEncriptarSHA256Response|bool
     */
    public function EncriptarSHA256(\WSQuickShine\StructType\WSQuickShineEncriptarSHA256 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EncriptarSHA256($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \WSQuickShine\StructType\WSQuickShineEncriptarSHA256Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
