<?php

namespace WSQuickShine\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Eliminar ServiceType
 * @package WSQuickShine
 * @subpackage Services
 */
class WSQuickShineEliminar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named EliminarTipoCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineEliminarTipoCliente $parameters
     * @return \WSQuickShine\StructType\WSQuickShineEliminarTipoClienteResponse|bool
     */
    public function EliminarTipoCliente(\WSQuickShine\StructType\WSQuickShineEliminarTipoCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EliminarTipoCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EliminarCiudad
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineEliminarCiudad $parameters
     * @return \WSQuickShine\StructType\WSQuickShineEliminarCiudadResponse|bool
     */
    public function EliminarCiudad(\WSQuickShine\StructType\WSQuickShineEliminarCiudad $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EliminarCiudad($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EliminarEstado
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineEliminarEstado $parameters
     * @return \WSQuickShine\StructType\WSQuickShineEliminarEstadoResponse|bool
     */
    public function EliminarEstado(\WSQuickShine\StructType\WSQuickShineEliminarEstado $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EliminarEstado($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EliminarPais
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineEliminarPais $parameters
     * @return \WSQuickShine\StructType\WSQuickShineEliminarPaisResponse|bool
     */
    public function EliminarPais(\WSQuickShine\StructType\WSQuickShineEliminarPais $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EliminarPais($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EliminarMetodoPago
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineEliminarMetodoPago $parameters
     * @return \WSQuickShine\StructType\WSQuickShineEliminarMetodoPagoResponse|bool
     */
    public function EliminarMetodoPago(\WSQuickShine\StructType\WSQuickShineEliminarMetodoPago $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EliminarMetodoPago($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EliminarCondicionesPago
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineEliminarCondicionesPago $parameters
     * @return \WSQuickShine\StructType\WSQuickShineEliminarCondicionesPagoResponse|bool
     */
    public function EliminarCondicionesPago(\WSQuickShine\StructType\WSQuickShineEliminarCondicionesPago $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EliminarCondicionesPago($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EliminarIVA
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineEliminarIVA $parameters
     * @return \WSQuickShine\StructType\WSQuickShineEliminarIVAResponse|bool
     */
    public function EliminarIVA(\WSQuickShine\StructType\WSQuickShineEliminarIVA $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EliminarIVA($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EliminarBanco
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineEliminarBanco $parameters
     * @return \WSQuickShine\StructType\WSQuickShineEliminarBancoResponse|bool
     */
    public function EliminarBanco(\WSQuickShine\StructType\WSQuickShineEliminarBanco $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EliminarBanco($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EliminarCuentaBancaria
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineEliminarCuentaBancaria $parameters
     * @return \WSQuickShine\StructType\WSQuickShineEliminarCuentaBancariaResponse|bool
     */
    public function EliminarCuentaBancaria(\WSQuickShine\StructType\WSQuickShineEliminarCuentaBancaria $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EliminarCuentaBancaria($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EliminarRegimenFiscal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineEliminarRegimenFiscal $parameters
     * @return \WSQuickShine\StructType\WSQuickShineEliminarRegimenFiscalResponse|bool
     */
    public function EliminarRegimenFiscal(\WSQuickShine\StructType\WSQuickShineEliminarRegimenFiscal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EliminarRegimenFiscal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EliminarTipoProducto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineEliminarTipoProducto $parameters
     * @return \WSQuickShine\StructType\WSQuickShineEliminarTipoProductoResponse|bool
     */
    public function EliminarTipoProducto(\WSQuickShine\StructType\WSQuickShineEliminarTipoProducto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EliminarTipoProducto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EliminarSerieFranquicias
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineEliminarSerieFranquicias $parameters
     * @return \WSQuickShine\StructType\WSQuickShineEliminarSerieFranquiciasResponse|bool
     */
    public function EliminarSerieFranquicias(\WSQuickShine\StructType\WSQuickShineEliminarSerieFranquicias $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EliminarSerieFranquicias($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EliminarProducto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineEliminarProducto $parameters
     * @return \WSQuickShine\StructType\WSQuickShineEliminarProductoResponse|bool
     */
    public function EliminarProducto(\WSQuickShine\StructType\WSQuickShineEliminarProducto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EliminarProducto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \WSQuickShine\StructType\WSQuickShineEliminarBancoResponse|\WSQuickShine\StructType\WSQuickShineEliminarCiudadResponse|\WSQuickShine\StructType\WSQuickShineEliminarCondicionesPagoResponse|\WSQuickShine\StructType\WSQuickShineEliminarCuentaBancariaResponse|\WSQuickShine\StructType\WSQuickShineEliminarEstadoResponse|\WSQuickShine\StructType\WSQuickShineEliminarIVAResponse|\WSQuickShine\StructType\WSQuickShineEliminarMetodoPagoResponse|\WSQuickShine\StructType\WSQuickShineEliminarPaisResponse|\WSQuickShine\StructType\WSQuickShineEliminarProductoResponse|\WSQuickShine\StructType\WSQuickShineEliminarRegimenFiscalResponse|\WSQuickShine\StructType\WSQuickShineEliminarSerieFranquiciasResponse|\WSQuickShine\StructType\WSQuickShineEliminarTipoClienteResponse|\WSQuickShine\StructType\WSQuickShineEliminarTipoProductoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
