<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://modulos.misconsultas.com.mx:4443/WebServices/WSQuickShine/WSQuickShine.svc?singleWsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://modulos.misconsultas.com.mx:4443/WebServices/WSQuickShine/WSQuickShine.svc?singleWsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \WSQuickShine\WSQuickShineClassMap::get(),
);
/**
 * Samples for Iniciar ServiceType
 */
$iniciar = new \WSQuickShine\ServiceType\WSQuickShineIniciar($options);
/**
 * Sample call for IniciarSesion operation/method
 */
if ($iniciar->IniciarSesion(new \WSQuickShine\StructType\WSQuickShineIniciarSesion()) !== false) {
    print_r($iniciar->getResult());
} else {
    print_r($iniciar->getLastError());
}
/**
 * Samples for Valida ServiceType
 */
$valida = new \WSQuickShine\ServiceType\WSQuickShineValida($options);
/**
 * Sample call for ValidaToken operation/method
 */
if ($valida->ValidaToken(new \WSQuickShine\StructType\WSQuickShineValidaToken()) !== false) {
    print_r($valida->getResult());
} else {
    print_r($valida->getLastError());
}
/**
 * Samples for Encriptar ServiceType
 */
$encriptar = new \WSQuickShine\ServiceType\WSQuickShineEncriptar($options);
/**
 * Sample call for EncriptarSHA256 operation/method
 */
if ($encriptar->EncriptarSHA256(new \WSQuickShine\StructType\WSQuickShineEncriptarSHA256()) !== false) {
    print_r($encriptar->getResult());
} else {
    print_r($encriptar->getLastError());
}
/**
 * Samples for Desencriptar ServiceType
 */
$desencriptar = new \WSQuickShine\ServiceType\WSQuickShineDesencriptar($options);
/**
 * Sample call for DesencriptarSHA256 operation/method
 */
if ($desencriptar->DesencriptarSHA256(new \WSQuickShine\StructType\WSQuickShineDesencriptarSHA256()) !== false) {
    print_r($desencriptar->getResult());
} else {
    print_r($desencriptar->getLastError());
}
/**
 * Samples for Insertar ServiceType
 */
$insertar = new \WSQuickShine\ServiceType\WSQuickShineInsertar($options);
/**
 * Sample call for InsertarCliente operation/method
 */
if ($insertar->InsertarCliente(new \WSQuickShine\StructType\WSQuickShineInsertarCliente()) !== false) {
    print_r($insertar->getResult());
} else {
    print_r($insertar->getLastError());
}
/**
 * Sample call for InsertarProducto operation/method
 */
if ($insertar->InsertarProducto(new \WSQuickShine\StructType\WSQuickShineInsertarProducto()) !== false) {
    print_r($insertar->getResult());
} else {
    print_r($insertar->getLastError());
}
/**
 * Sample call for InsertarFactura operation/method
 */
if ($insertar->InsertarFactura(new \WSQuickShine\StructType\WSQuickShineInsertarFactura()) !== false) {
    print_r($insertar->getResult());
} else {
    print_r($insertar->getLastError());
}
/**
 * Sample call for InsertarNotaCreditoCliente operation/method
 */
if ($insertar->InsertarNotaCreditoCliente(new \WSQuickShine\StructType\WSQuickShineInsertarNotaCreditoCliente()) !== false) {
    print_r($insertar->getResult());
} else {
    print_r($insertar->getLastError());
}
/**
 * Sample call for InsertarTipoCliente operation/method
 */
if ($insertar->InsertarTipoCliente(new \WSQuickShine\StructType\WSQuickShineInsertarTipoCliente()) !== false) {
    print_r($insertar->getResult());
} else {
    print_r($insertar->getLastError());
}
/**
 * Sample call for InsertarCiudad operation/method
 */
if ($insertar->InsertarCiudad(new \WSQuickShine\StructType\WSQuickShineInsertarCiudad()) !== false) {
    print_r($insertar->getResult());
} else {
    print_r($insertar->getLastError());
}
/**
 * Sample call for InsertarEstado operation/method
 */
if ($insertar->InsertarEstado(new \WSQuickShine\StructType\WSQuickShineInsertarEstado()) !== false) {
    print_r($insertar->getResult());
} else {
    print_r($insertar->getLastError());
}
/**
 * Sample call for InsertarPais operation/method
 */
if ($insertar->InsertarPais(new \WSQuickShine\StructType\WSQuickShineInsertarPais()) !== false) {
    print_r($insertar->getResult());
} else {
    print_r($insertar->getLastError());
}
/**
 * Sample call for InsertarMetodoPago operation/method
 */
if ($insertar->InsertarMetodoPago(new \WSQuickShine\StructType\WSQuickShineInsertarMetodoPago()) !== false) {
    print_r($insertar->getResult());
} else {
    print_r($insertar->getLastError());
}
/**
 * Sample call for InsertarCondicionesPago operation/method
 */
if ($insertar->InsertarCondicionesPago(new \WSQuickShine\StructType\WSQuickShineInsertarCondicionesPago()) !== false) {
    print_r($insertar->getResult());
} else {
    print_r($insertar->getLastError());
}
/**
 * Sample call for InsertarIVA operation/method
 */
if ($insertar->InsertarIVA(new \WSQuickShine\StructType\WSQuickShineInsertarIVA()) !== false) {
    print_r($insertar->getResult());
} else {
    print_r($insertar->getLastError());
}
/**
 * Sample call for InsertarBanco operation/method
 */
if ($insertar->InsertarBanco(new \WSQuickShine\StructType\WSQuickShineInsertarBanco()) !== false) {
    print_r($insertar->getResult());
} else {
    print_r($insertar->getLastError());
}
/**
 * Sample call for InsertarCuentaBancaria operation/method
 */
if ($insertar->InsertarCuentaBancaria(new \WSQuickShine\StructType\WSQuickShineInsertarCuentaBancaria()) !== false) {
    print_r($insertar->getResult());
} else {
    print_r($insertar->getLastError());
}
/**
 * Sample call for InsertarRegimenFiscal operation/method
 */
if ($insertar->InsertarRegimenFiscal(new \WSQuickShine\StructType\WSQuickShineInsertarRegimenFiscal()) !== false) {
    print_r($insertar->getResult());
} else {
    print_r($insertar->getLastError());
}
/**
 * Sample call for InsertarCobranzaCliente operation/method
 */
if ($insertar->InsertarCobranzaCliente(new \WSQuickShine\StructType\WSQuickShineInsertarCobranzaCliente()) !== false) {
    print_r($insertar->getResult());
} else {
    print_r($insertar->getLastError());
}
/**
 * Sample call for InsertarTipoProducto operation/method
 */
if ($insertar->InsertarTipoProducto(new \WSQuickShine\StructType\WSQuickShineInsertarTipoProducto()) !== false) {
    print_r($insertar->getResult());
} else {
    print_r($insertar->getLastError());
}
/**
 * Sample call for InsertarSerieFranquicias operation/method
 */
if ($insertar->InsertarSerieFranquicias(new \WSQuickShine\StructType\WSQuickShineInsertarSerieFranquicias()) !== false) {
    print_r($insertar->getResult());
} else {
    print_r($insertar->getLastError());
}
/**
 * Samples for Editar ServiceType
 */
$editar = new \WSQuickShine\ServiceType\WSQuickShineEditar($options);
/**
 * Sample call for EditarCliente operation/method
 */
if ($editar->EditarCliente(new \WSQuickShine\StructType\WSQuickShineEditarCliente()) !== false) {
    print_r($editar->getResult());
} else {
    print_r($editar->getLastError());
}
/**
 * Sample call for EditarTipoCliente operation/method
 */
if ($editar->EditarTipoCliente(new \WSQuickShine\StructType\WSQuickShineEditarTipoCliente()) !== false) {
    print_r($editar->getResult());
} else {
    print_r($editar->getLastError());
}
/**
 * Sample call for EditarCiudad operation/method
 */
if ($editar->EditarCiudad(new \WSQuickShine\StructType\WSQuickShineEditarCiudad()) !== false) {
    print_r($editar->getResult());
} else {
    print_r($editar->getLastError());
}
/**
 * Sample call for EditarEstado operation/method
 */
if ($editar->EditarEstado(new \WSQuickShine\StructType\WSQuickShineEditarEstado()) !== false) {
    print_r($editar->getResult());
} else {
    print_r($editar->getLastError());
}
/**
 * Sample call for EditarPais operation/method
 */
if ($editar->EditarPais(new \WSQuickShine\StructType\WSQuickShineEditarPais()) !== false) {
    print_r($editar->getResult());
} else {
    print_r($editar->getLastError());
}
/**
 * Sample call for EditarMetodoPago operation/method
 */
if ($editar->EditarMetodoPago(new \WSQuickShine\StructType\WSQuickShineEditarMetodoPago()) !== false) {
    print_r($editar->getResult());
} else {
    print_r($editar->getLastError());
}
/**
 * Sample call for EditarCondicionesPago operation/method
 */
if ($editar->EditarCondicionesPago(new \WSQuickShine\StructType\WSQuickShineEditarCondicionesPago()) !== false) {
    print_r($editar->getResult());
} else {
    print_r($editar->getLastError());
}
/**
 * Sample call for EditarIVA operation/method
 */
if ($editar->EditarIVA(new \WSQuickShine\StructType\WSQuickShineEditarIVA()) !== false) {
    print_r($editar->getResult());
} else {
    print_r($editar->getLastError());
}
/**
 * Sample call for EditarBanco operation/method
 */
if ($editar->EditarBanco(new \WSQuickShine\StructType\WSQuickShineEditarBanco()) !== false) {
    print_r($editar->getResult());
} else {
    print_r($editar->getLastError());
}
/**
 * Sample call for EditarCuentaBancaria operation/method
 */
if ($editar->EditarCuentaBancaria(new \WSQuickShine\StructType\WSQuickShineEditarCuentaBancaria()) !== false) {
    print_r($editar->getResult());
} else {
    print_r($editar->getLastError());
}
/**
 * Sample call for EditarProducto operation/method
 */
if ($editar->EditarProducto(new \WSQuickShine\StructType\WSQuickShineEditarProducto()) !== false) {
    print_r($editar->getResult());
} else {
    print_r($editar->getLastError());
}
/**
 * Sample call for EditarRegimenFiscal operation/method
 */
if ($editar->EditarRegimenFiscal(new \WSQuickShine\StructType\WSQuickShineEditarRegimenFiscal()) !== false) {
    print_r($editar->getResult());
} else {
    print_r($editar->getLastError());
}
/**
 * Sample call for EditarTipoProducto operation/method
 */
if ($editar->EditarTipoProducto(new \WSQuickShine\StructType\WSQuickShineEditarTipoProducto()) !== false) {
    print_r($editar->getResult());
} else {
    print_r($editar->getLastError());
}
/**
 * Sample call for EditarSerieFranquicias operation/method
 */
if ($editar->EditarSerieFranquicias(new \WSQuickShine\StructType\WSQuickShineEditarSerieFranquicias()) !== false) {
    print_r($editar->getResult());
} else {
    print_r($editar->getLastError());
}
/**
 * Samples for Estatus ServiceType
 */
$estatus = new \WSQuickShine\ServiceType\WSQuickShineEstatus($options);
/**
 * Sample call for EstatusCliente operation/method
 */
if ($estatus->EstatusCliente(new \WSQuickShine\StructType\WSQuickShineEstatusCliente()) !== false) {
    print_r($estatus->getResult());
} else {
    print_r($estatus->getLastError());
}
/**
 * Sample call for EstatusProducto operation/method
 */
if ($estatus->EstatusProducto(new \WSQuickShine\StructType\WSQuickShineEstatusProducto()) !== false) {
    print_r($estatus->getResult());
} else {
    print_r($estatus->getLastError());
}
/**
 * Sample call for EstatusFactura operation/method
 */
if ($estatus->EstatusFactura(new \WSQuickShine\StructType\WSQuickShineEstatusFactura()) !== false) {
    print_r($estatus->getResult());
} else {
    print_r($estatus->getLastError());
}
/**
 * Sample call for EstatusNotaCreditoCliente operation/method
 */
if ($estatus->EstatusNotaCreditoCliente(new \WSQuickShine\StructType\WSQuickShineEstatusNotaCreditoCliente()) !== false) {
    print_r($estatus->getResult());
} else {
    print_r($estatus->getLastError());
}
/**
 * Sample call for EstatusCobranzaCliente operation/method
 */
if ($estatus->EstatusCobranzaCliente(new \WSQuickShine\StructType\WSQuickShineEstatusCobranzaCliente()) !== false) {
    print_r($estatus->getResult());
} else {
    print_r($estatus->getLastError());
}
/**
 * Samples for Concepto ServiceType
 */
$concepto = new \WSQuickShine\ServiceType\WSQuickShineConcepto($options);
/**
 * Sample call for ConceptoContProducto operation/method
 */
if ($concepto->ConceptoContProducto(new \WSQuickShine\StructType\WSQuickShineConceptoContProducto()) !== false) {
    print_r($concepto->getResult());
} else {
    print_r($concepto->getLastError());
}
/**
 * Samples for Cancelar ServiceType
 */
$cancelar = new \WSQuickShine\ServiceType\WSQuickShineCancelar($options);
/**
 * Sample call for CancelarFactura operation/method
 */
if ($cancelar->CancelarFactura(new \WSQuickShine\StructType\WSQuickShineCancelarFactura()) !== false) {
    print_r($cancelar->getResult());
} else {
    print_r($cancelar->getLastError());
}
/**
 * Sample call for CancelarNotaCreditoCliente operation/method
 */
if ($cancelar->CancelarNotaCreditoCliente(new \WSQuickShine\StructType\WSQuickShineCancelarNotaCreditoCliente()) !== false) {
    print_r($cancelar->getResult());
} else {
    print_r($cancelar->getLastError());
}
/**
 * Sample call for CancelarCobranzaCliente operation/method
 */
if ($cancelar->CancelarCobranzaCliente(new \WSQuickShine\StructType\WSQuickShineCancelarCobranzaCliente()) !== false) {
    print_r($cancelar->getResult());
} else {
    print_r($cancelar->getLastError());
}
/**
 * Samples for Eliminar ServiceType
 */
$eliminar = new \WSQuickShine\ServiceType\WSQuickShineEliminar($options);
/**
 * Sample call for EliminarTipoCliente operation/method
 */
if ($eliminar->EliminarTipoCliente(new \WSQuickShine\StructType\WSQuickShineEliminarTipoCliente()) !== false) {
    print_r($eliminar->getResult());
} else {
    print_r($eliminar->getLastError());
}
/**
 * Sample call for EliminarCiudad operation/method
 */
if ($eliminar->EliminarCiudad(new \WSQuickShine\StructType\WSQuickShineEliminarCiudad()) !== false) {
    print_r($eliminar->getResult());
} else {
    print_r($eliminar->getLastError());
}
/**
 * Sample call for EliminarEstado operation/method
 */
if ($eliminar->EliminarEstado(new \WSQuickShine\StructType\WSQuickShineEliminarEstado()) !== false) {
    print_r($eliminar->getResult());
} else {
    print_r($eliminar->getLastError());
}
/**
 * Sample call for EliminarPais operation/method
 */
if ($eliminar->EliminarPais(new \WSQuickShine\StructType\WSQuickShineEliminarPais()) !== false) {
    print_r($eliminar->getResult());
} else {
    print_r($eliminar->getLastError());
}
/**
 * Sample call for EliminarMetodoPago operation/method
 */
if ($eliminar->EliminarMetodoPago(new \WSQuickShine\StructType\WSQuickShineEliminarMetodoPago()) !== false) {
    print_r($eliminar->getResult());
} else {
    print_r($eliminar->getLastError());
}
/**
 * Sample call for EliminarCondicionesPago operation/method
 */
if ($eliminar->EliminarCondicionesPago(new \WSQuickShine\StructType\WSQuickShineEliminarCondicionesPago()) !== false) {
    print_r($eliminar->getResult());
} else {
    print_r($eliminar->getLastError());
}
/**
 * Sample call for EliminarIVA operation/method
 */
if ($eliminar->EliminarIVA(new \WSQuickShine\StructType\WSQuickShineEliminarIVA()) !== false) {
    print_r($eliminar->getResult());
} else {
    print_r($eliminar->getLastError());
}
/**
 * Sample call for EliminarBanco operation/method
 */
if ($eliminar->EliminarBanco(new \WSQuickShine\StructType\WSQuickShineEliminarBanco()) !== false) {
    print_r($eliminar->getResult());
} else {
    print_r($eliminar->getLastError());
}
/**
 * Sample call for EliminarCuentaBancaria operation/method
 */
if ($eliminar->EliminarCuentaBancaria(new \WSQuickShine\StructType\WSQuickShineEliminarCuentaBancaria()) !== false) {
    print_r($eliminar->getResult());
} else {
    print_r($eliminar->getLastError());
}
/**
 * Sample call for EliminarRegimenFiscal operation/method
 */
if ($eliminar->EliminarRegimenFiscal(new \WSQuickShine\StructType\WSQuickShineEliminarRegimenFiscal()) !== false) {
    print_r($eliminar->getResult());
} else {
    print_r($eliminar->getLastError());
}
/**
 * Sample call for EliminarTipoProducto operation/method
 */
if ($eliminar->EliminarTipoProducto(new \WSQuickShine\StructType\WSQuickShineEliminarTipoProducto()) !== false) {
    print_r($eliminar->getResult());
} else {
    print_r($eliminar->getLastError());
}
/**
 * Sample call for EliminarSerieFranquicias operation/method
 */
if ($eliminar->EliminarSerieFranquicias(new \WSQuickShine\StructType\WSQuickShineEliminarSerieFranquicias()) !== false) {
    print_r($eliminar->getResult());
} else {
    print_r($eliminar->getLastError());
}
/**
 * Sample call for EliminarProducto operation/method
 */
if ($eliminar->EliminarProducto(new \WSQuickShine\StructType\WSQuickShineEliminarProducto()) !== false) {
    print_r($eliminar->getResult());
} else {
    print_r($eliminar->getLastError());
}
/**
 * Samples for Puede ServiceType
 */
$puede = new \WSQuickShine\ServiceType\WSQuickShinePuede($options);
/**
 * Sample call for PuedeInsertarFactura operation/method
 */
if ($puede->PuedeInsertarFactura(new \WSQuickShine\StructType\WSQuickShinePuedeInsertarFactura()) !== false) {
    print_r($puede->getResult());
} else {
    print_r($puede->getLastError());
}
/**
 * Sample call for PuedeCancelarFactura operation/method
 */
if ($puede->PuedeCancelarFactura(new \WSQuickShine\StructType\WSQuickShinePuedeCancelarFactura()) !== false) {
    print_r($puede->getResult());
} else {
    print_r($puede->getLastError());
}
/**
 * Sample call for PuedeInsertarNotaCreditoCliente operation/method
 */
if ($puede->PuedeInsertarNotaCreditoCliente(new \WSQuickShine\StructType\WSQuickShinePuedeInsertarNotaCreditoCliente()) !== false) {
    print_r($puede->getResult());
} else {
    print_r($puede->getLastError());
}
/**
 * Sample call for PuedeCancelarNotaCreditoCliente operation/method
 */
if ($puede->PuedeCancelarNotaCreditoCliente(new \WSQuickShine\StructType\WSQuickShinePuedeCancelarNotaCreditoCliente()) !== false) {
    print_r($puede->getResult());
} else {
    print_r($puede->getLastError());
}
/**
 * Sample call for PuedeInsertarCobranzaCliente operation/method
 */
if ($puede->PuedeInsertarCobranzaCliente(new \WSQuickShine\StructType\WSQuickShinePuedeInsertarCobranzaCliente()) !== false) {
    print_r($puede->getResult());
} else {
    print_r($puede->getLastError());
}
/**
 * Sample call for PuedeCancelarCobranzaCliente operation/method
 */
if ($puede->PuedeCancelarCobranzaCliente(new \WSQuickShine\StructType\WSQuickShinePuedeCancelarCobranzaCliente()) !== false) {
    print_r($puede->getResult());
} else {
    print_r($puede->getLastError());
}
