<?php

namespace WSQuickShine\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DesencriptarSHA256Response StructType
 * @package WSQuickShine
 * @subpackage Structs
 */
class WSQuickShineDesencriptarSHA256Response extends AbstractStructBase
{
    /**
     * The DesencriptarSHA256Result
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DesencriptarSHA256Result;
    /**
     * Constructor method for DesencriptarSHA256Response
     * @uses WSQuickShineDesencriptarSHA256Response::setDesencriptarSHA256Result()
     * @param string $desencriptarSHA256Result
     */
    public function __construct($desencriptarSHA256Result = null)
    {
        $this
            ->setDesencriptarSHA256Result($desencriptarSHA256Result);
    }
    /**
     * Get DesencriptarSHA256Result value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDesencriptarSHA256Result()
    {
        return isset($this->DesencriptarSHA256Result) ? $this->DesencriptarSHA256Result : null;
    }
    /**
     * Set DesencriptarSHA256Result value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $desencriptarSHA256Result
     * @return \WSQuickShine\StructType\WSQuickShineDesencriptarSHA256Response
     */
    public function setDesencriptarSHA256Result($desencriptarSHA256Result = null)
    {
        // validation for constraint: string
        if (!is_null($desencriptarSHA256Result) && !is_string($desencriptarSHA256Result)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($desencriptarSHA256Result, true), gettype($desencriptarSHA256Result)), __LINE__);
        }
        if (is_null($desencriptarSHA256Result) || (is_array($desencriptarSHA256Result) && empty($desencriptarSHA256Result))) {
            unset($this->DesencriptarSHA256Result);
        } else {
            $this->DesencriptarSHA256Result = $desencriptarSHA256Result;
        }
        return $this;
    }
}
