<?php

namespace WSQuickShine\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Puede ServiceType
 * @package WSQuickShine
 * @subpackage Services
 */
class WSQuickShinePuede extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PuedeInsertarFactura
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShinePuedeInsertarFactura $parameters
     * @return \WSQuickShine\StructType\WSQuickShinePuedeInsertarFacturaResponse|bool
     */
    public function PuedeInsertarFactura(\WSQuickShine\StructType\WSQuickShinePuedeInsertarFactura $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PuedeInsertarFactura($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PuedeCancelarFactura
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShinePuedeCancelarFactura $parameters
     * @return \WSQuickShine\StructType\WSQuickShinePuedeCancelarFacturaResponse|bool
     */
    public function PuedeCancelarFactura(\WSQuickShine\StructType\WSQuickShinePuedeCancelarFactura $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PuedeCancelarFactura($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PuedeInsertarNotaCreditoCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShinePuedeInsertarNotaCreditoCliente $parameters
     * @return \WSQuickShine\StructType\WSQuickShinePuedeInsertarNotaCreditoClienteResponse|bool
     */
    public function PuedeInsertarNotaCreditoCliente(\WSQuickShine\StructType\WSQuickShinePuedeInsertarNotaCreditoCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PuedeInsertarNotaCreditoCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PuedeCancelarNotaCreditoCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShinePuedeCancelarNotaCreditoCliente $parameters
     * @return \WSQuickShine\StructType\WSQuickShinePuedeCancelarNotaCreditoClienteResponse|bool
     */
    public function PuedeCancelarNotaCreditoCliente(\WSQuickShine\StructType\WSQuickShinePuedeCancelarNotaCreditoCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PuedeCancelarNotaCreditoCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PuedeInsertarCobranzaCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShinePuedeInsertarCobranzaCliente $parameters
     * @return \WSQuickShine\StructType\WSQuickShinePuedeInsertarCobranzaClienteResponse|bool
     */
    public function PuedeInsertarCobranzaCliente(\WSQuickShine\StructType\WSQuickShinePuedeInsertarCobranzaCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PuedeInsertarCobranzaCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PuedeCancelarCobranzaCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShinePuedeCancelarCobranzaCliente $parameters
     * @return \WSQuickShine\StructType\WSQuickShinePuedeCancelarCobranzaClienteResponse|bool
     */
    public function PuedeCancelarCobranzaCliente(\WSQuickShine\StructType\WSQuickShinePuedeCancelarCobranzaCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PuedeCancelarCobranzaCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \WSQuickShine\StructType\WSQuickShinePuedeCancelarCobranzaClienteResponse|\WSQuickShine\StructType\WSQuickShinePuedeCancelarFacturaResponse|\WSQuickShine\StructType\WSQuickShinePuedeCancelarNotaCreditoClienteResponse|\WSQuickShine\StructType\WSQuickShinePuedeInsertarCobranzaClienteResponse|\WSQuickShine\StructType\WSQuickShinePuedeInsertarFacturaResponse|\WSQuickShine\StructType\WSQuickShinePuedeInsertarNotaCreditoClienteResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
