<?php

namespace WSQuickShine\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Insertar ServiceType
 * @package WSQuickShine
 * @subpackage Services
 */
class WSQuickShineInsertar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named InsertarCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineInsertarCliente $parameters
     * @return \WSQuickShine\StructType\WSQuickShineInsertarClienteResponse|bool
     */
    public function InsertarCliente(\WSQuickShine\StructType\WSQuickShineInsertarCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertarCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertarProducto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineInsertarProducto $parameters
     * @return \WSQuickShine\StructType\WSQuickShineInsertarProductoResponse|bool
     */
    public function InsertarProducto(\WSQuickShine\StructType\WSQuickShineInsertarProducto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertarProducto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertarFactura
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineInsertarFactura $parameters
     * @return \WSQuickShine\StructType\WSQuickShineInsertarFacturaResponse|bool
     */
    public function InsertarFactura(\WSQuickShine\StructType\WSQuickShineInsertarFactura $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertarFactura($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertarNotaCreditoCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineInsertarNotaCreditoCliente $parameters
     * @return \WSQuickShine\StructType\WSQuickShineInsertarNotaCreditoClienteResponse|bool
     */
    public function InsertarNotaCreditoCliente(\WSQuickShine\StructType\WSQuickShineInsertarNotaCreditoCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertarNotaCreditoCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertarTipoCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineInsertarTipoCliente $parameters
     * @return \WSQuickShine\StructType\WSQuickShineInsertarTipoClienteResponse|bool
     */
    public function InsertarTipoCliente(\WSQuickShine\StructType\WSQuickShineInsertarTipoCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertarTipoCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertarCiudad
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineInsertarCiudad $parameters
     * @return \WSQuickShine\StructType\WSQuickShineInsertarCiudadResponse|bool
     */
    public function InsertarCiudad(\WSQuickShine\StructType\WSQuickShineInsertarCiudad $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertarCiudad($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertarEstado
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineInsertarEstado $parameters
     * @return \WSQuickShine\StructType\WSQuickShineInsertarEstadoResponse|bool
     */
    public function InsertarEstado(\WSQuickShine\StructType\WSQuickShineInsertarEstado $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertarEstado($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertarPais
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineInsertarPais $parameters
     * @return \WSQuickShine\StructType\WSQuickShineInsertarPaisResponse|bool
     */
    public function InsertarPais(\WSQuickShine\StructType\WSQuickShineInsertarPais $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertarPais($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertarMetodoPago
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineInsertarMetodoPago $parameters
     * @return \WSQuickShine\StructType\WSQuickShineInsertarMetodoPagoResponse|bool
     */
    public function InsertarMetodoPago(\WSQuickShine\StructType\WSQuickShineInsertarMetodoPago $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertarMetodoPago($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertarCondicionesPago
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineInsertarCondicionesPago $parameters
     * @return \WSQuickShine\StructType\WSQuickShineInsertarCondicionesPagoResponse|bool
     */
    public function InsertarCondicionesPago(\WSQuickShine\StructType\WSQuickShineInsertarCondicionesPago $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertarCondicionesPago($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertarIVA
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineInsertarIVA $parameters
     * @return \WSQuickShine\StructType\WSQuickShineInsertarIVAResponse|bool
     */
    public function InsertarIVA(\WSQuickShine\StructType\WSQuickShineInsertarIVA $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertarIVA($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertarBanco
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineInsertarBanco $parameters
     * @return \WSQuickShine\StructType\WSQuickShineInsertarBancoResponse|bool
     */
    public function InsertarBanco(\WSQuickShine\StructType\WSQuickShineInsertarBanco $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertarBanco($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertarCuentaBancaria
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineInsertarCuentaBancaria $parameters
     * @return \WSQuickShine\StructType\WSQuickShineInsertarCuentaBancariaResponse|bool
     */
    public function InsertarCuentaBancaria(\WSQuickShine\StructType\WSQuickShineInsertarCuentaBancaria $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertarCuentaBancaria($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertarRegimenFiscal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineInsertarRegimenFiscal $parameters
     * @return \WSQuickShine\StructType\WSQuickShineInsertarRegimenFiscalResponse|bool
     */
    public function InsertarRegimenFiscal(\WSQuickShine\StructType\WSQuickShineInsertarRegimenFiscal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertarRegimenFiscal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertarCobranzaCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineInsertarCobranzaCliente $parameters
     * @return \WSQuickShine\StructType\WSQuickShineInsertarCobranzaClienteResponse|bool
     */
    public function InsertarCobranzaCliente(\WSQuickShine\StructType\WSQuickShineInsertarCobranzaCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertarCobranzaCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertarTipoProducto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineInsertarTipoProducto $parameters
     * @return \WSQuickShine\StructType\WSQuickShineInsertarTipoProductoResponse|bool
     */
    public function InsertarTipoProducto(\WSQuickShine\StructType\WSQuickShineInsertarTipoProducto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertarTipoProducto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertarSerieFranquicias
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineInsertarSerieFranquicias $parameters
     * @return \WSQuickShine\StructType\WSQuickShineInsertarSerieFranquiciasResponse|bool
     */
    public function InsertarSerieFranquicias(\WSQuickShine\StructType\WSQuickShineInsertarSerieFranquicias $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertarSerieFranquicias($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \WSQuickShine\StructType\WSQuickShineInsertarBancoResponse|\WSQuickShine\StructType\WSQuickShineInsertarCiudadResponse|\WSQuickShine\StructType\WSQuickShineInsertarClienteResponse|\WSQuickShine\StructType\WSQuickShineInsertarCobranzaClienteResponse|\WSQuickShine\StructType\WSQuickShineInsertarCondicionesPagoResponse|\WSQuickShine\StructType\WSQuickShineInsertarCuentaBancariaResponse|\WSQuickShine\StructType\WSQuickShineInsertarEstadoResponse|\WSQuickShine\StructType\WSQuickShineInsertarFacturaResponse|\WSQuickShine\StructType\WSQuickShineInsertarIVAResponse|\WSQuickShine\StructType\WSQuickShineInsertarMetodoPagoResponse|\WSQuickShine\StructType\WSQuickShineInsertarNotaCreditoClienteResponse|\WSQuickShine\StructType\WSQuickShineInsertarPaisResponse|\WSQuickShine\StructType\WSQuickShineInsertarProductoResponse|\WSQuickShine\StructType\WSQuickShineInsertarRegimenFiscalResponse|\WSQuickShine\StructType\WSQuickShineInsertarSerieFranquiciasResponse|\WSQuickShine\StructType\WSQuickShineInsertarTipoClienteResponse|\WSQuickShine\StructType\WSQuickShineInsertarTipoProductoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
