<?php

namespace WSQuickShine\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Editar ServiceType
 * @package WSQuickShine
 * @subpackage Services
 */
class WSQuickShineEditar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named EditarCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineEditarCliente $parameters
     * @return \WSQuickShine\StructType\WSQuickShineEditarClienteResponse|bool
     */
    public function EditarCliente(\WSQuickShine\StructType\WSQuickShineEditarCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EditarCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditarTipoCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineEditarTipoCliente $parameters
     * @return \WSQuickShine\StructType\WSQuickShineEditarTipoClienteResponse|bool
     */
    public function EditarTipoCliente(\WSQuickShine\StructType\WSQuickShineEditarTipoCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EditarTipoCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditarCiudad
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineEditarCiudad $parameters
     * @return \WSQuickShine\StructType\WSQuickShineEditarCiudadResponse|bool
     */
    public function EditarCiudad(\WSQuickShine\StructType\WSQuickShineEditarCiudad $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EditarCiudad($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditarEstado
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineEditarEstado $parameters
     * @return \WSQuickShine\StructType\WSQuickShineEditarEstadoResponse|bool
     */
    public function EditarEstado(\WSQuickShine\StructType\WSQuickShineEditarEstado $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EditarEstado($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditarPais
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineEditarPais $parameters
     * @return \WSQuickShine\StructType\WSQuickShineEditarPaisResponse|bool
     */
    public function EditarPais(\WSQuickShine\StructType\WSQuickShineEditarPais $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EditarPais($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditarMetodoPago
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineEditarMetodoPago $parameters
     * @return \WSQuickShine\StructType\WSQuickShineEditarMetodoPagoResponse|bool
     */
    public function EditarMetodoPago(\WSQuickShine\StructType\WSQuickShineEditarMetodoPago $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EditarMetodoPago($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditarCondicionesPago
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineEditarCondicionesPago $parameters
     * @return \WSQuickShine\StructType\WSQuickShineEditarCondicionesPagoResponse|bool
     */
    public function EditarCondicionesPago(\WSQuickShine\StructType\WSQuickShineEditarCondicionesPago $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EditarCondicionesPago($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditarIVA
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineEditarIVA $parameters
     * @return \WSQuickShine\StructType\WSQuickShineEditarIVAResponse|bool
     */
    public function EditarIVA(\WSQuickShine\StructType\WSQuickShineEditarIVA $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EditarIVA($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditarBanco
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineEditarBanco $parameters
     * @return \WSQuickShine\StructType\WSQuickShineEditarBancoResponse|bool
     */
    public function EditarBanco(\WSQuickShine\StructType\WSQuickShineEditarBanco $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EditarBanco($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditarCuentaBancaria
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineEditarCuentaBancaria $parameters
     * @return \WSQuickShine\StructType\WSQuickShineEditarCuentaBancariaResponse|bool
     */
    public function EditarCuentaBancaria(\WSQuickShine\StructType\WSQuickShineEditarCuentaBancaria $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EditarCuentaBancaria($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditarProducto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineEditarProducto $parameters
     * @return \WSQuickShine\StructType\WSQuickShineEditarProductoResponse|bool
     */
    public function EditarProducto(\WSQuickShine\StructType\WSQuickShineEditarProducto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EditarProducto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditarRegimenFiscal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineEditarRegimenFiscal $parameters
     * @return \WSQuickShine\StructType\WSQuickShineEditarRegimenFiscalResponse|bool
     */
    public function EditarRegimenFiscal(\WSQuickShine\StructType\WSQuickShineEditarRegimenFiscal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EditarRegimenFiscal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditarTipoProducto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineEditarTipoProducto $parameters
     * @return \WSQuickShine\StructType\WSQuickShineEditarTipoProductoResponse|bool
     */
    public function EditarTipoProducto(\WSQuickShine\StructType\WSQuickShineEditarTipoProducto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EditarTipoProducto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditarSerieFranquicias
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineEditarSerieFranquicias $parameters
     * @return \WSQuickShine\StructType\WSQuickShineEditarSerieFranquiciasResponse|bool
     */
    public function EditarSerieFranquicias(\WSQuickShine\StructType\WSQuickShineEditarSerieFranquicias $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EditarSerieFranquicias($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \WSQuickShine\StructType\WSQuickShineEditarBancoResponse|\WSQuickShine\StructType\WSQuickShineEditarCiudadResponse|\WSQuickShine\StructType\WSQuickShineEditarClienteResponse|\WSQuickShine\StructType\WSQuickShineEditarCondicionesPagoResponse|\WSQuickShine\StructType\WSQuickShineEditarCuentaBancariaResponse|\WSQuickShine\StructType\WSQuickShineEditarEstadoResponse|\WSQuickShine\StructType\WSQuickShineEditarIVAResponse|\WSQuickShine\StructType\WSQuickShineEditarMetodoPagoResponse|\WSQuickShine\StructType\WSQuickShineEditarPaisResponse|\WSQuickShine\StructType\WSQuickShineEditarProductoResponse|\WSQuickShine\StructType\WSQuickShineEditarRegimenFiscalResponse|\WSQuickShine\StructType\WSQuickShineEditarSerieFranquiciasResponse|\WSQuickShine\StructType\WSQuickShineEditarTipoClienteResponse|\WSQuickShine\StructType\WSQuickShineEditarTipoProductoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
