<?php

namespace WSQuickShine\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Desencriptar ServiceType
 * @package WSQuickShine
 * @subpackage Services
 */
class WSQuickShineDesencriptar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DesencriptarSHA256
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineDesencriptarSHA256 $parameters
     * @return \WSQuickShine\StructType\WSQuickShineDesencriptarSHA256Response|bool
     */
    public function DesencriptarSHA256(\WSQuickShine\StructType\WSQuickShineDesencriptarSHA256 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DesencriptarSHA256($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \WSQuickShine\StructType\WSQuickShineDesencriptarSHA256Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
