<?php

namespace WSQuickShine\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cancelar ServiceType
 * @package WSQuickShine
 * @subpackage Services
 */
class WSQuickShineCancelar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CancelarFactura
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineCancelarFactura $parameters
     * @return \WSQuickShine\StructType\WSQuickShineCancelarFacturaResponse|bool
     */
    public function CancelarFactura(\WSQuickShine\StructType\WSQuickShineCancelarFactura $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CancelarFactura($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CancelarNotaCreditoCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineCancelarNotaCreditoCliente $parameters
     * @return \WSQuickShine\StructType\WSQuickShineCancelarNotaCreditoClienteResponse|bool
     */
    public function CancelarNotaCreditoCliente(\WSQuickShine\StructType\WSQuickShineCancelarNotaCreditoCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CancelarNotaCreditoCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CancelarCobranzaCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WSQuickShine\StructType\WSQuickShineCancelarCobranzaCliente $parameters
     * @return \WSQuickShine\StructType\WSQuickShineCancelarCobranzaClienteResponse|bool
     */
    public function CancelarCobranzaCliente(\WSQuickShine\StructType\WSQuickShineCancelarCobranzaCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CancelarCobranzaCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \WSQuickShine\StructType\WSQuickShineCancelarCobranzaClienteResponse|\WSQuickShine\StructType\WSQuickShineCancelarFacturaResponse|\WSQuickShine\StructType\WSQuickShineCancelarNotaCreditoClienteResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
