<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Iniciar ServiceType
 * @subpackage Services
 */
class Iniciar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named IniciarSesion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IniciarSesion $parameters
     * @return \StructType\IniciarSesionResponse|bool
     */
    public function IniciarSesion(\StructType\IniciarSesion $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IniciarSesion($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\IniciarSesionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
