<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Encriptar ServiceType
 * @subpackage Services
 */
class Encriptar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named EncriptarSHA256
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EncriptarSHA256 $parameters
     * @return \StructType\EncriptarSHA256Response|bool
     */
    public function EncriptarSHA256(\StructType\EncriptarSHA256 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EncriptarSHA256($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\EncriptarSHA256Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
