<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Valida ServiceType
 * @subpackage Services
 */
class Valida extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ValidaToken
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ValidaToken $parameters
     * @return \StructType\ValidaTokenResponse|bool
     */
    public function ValidaToken(\StructType\ValidaToken $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ValidaToken($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ValidaTokenResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
