<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Puede ServiceType
 * @subpackage Services
 */
class Puede extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PuedeInsertarFactura
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PuedeInsertarFactura $parameters
     * @return \StructType\PuedeInsertarFacturaResponse|bool
     */
    public function PuedeInsertarFactura(\StructType\PuedeInsertarFactura $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PuedeInsertarFactura($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PuedeCancelarFactura
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PuedeCancelarFactura $parameters
     * @return \StructType\PuedeCancelarFacturaResponse|bool
     */
    public function PuedeCancelarFactura(\StructType\PuedeCancelarFactura $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PuedeCancelarFactura($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PuedeInsertarNotaCreditoCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PuedeInsertarNotaCreditoCliente $parameters
     * @return \StructType\PuedeInsertarNotaCreditoClienteResponse|bool
     */
    public function PuedeInsertarNotaCreditoCliente(\StructType\PuedeInsertarNotaCreditoCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PuedeInsertarNotaCreditoCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PuedeCancelarNotaCreditoCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PuedeCancelarNotaCreditoCliente $parameters
     * @return \StructType\PuedeCancelarNotaCreditoClienteResponse|bool
     */
    public function PuedeCancelarNotaCreditoCliente(\StructType\PuedeCancelarNotaCreditoCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PuedeCancelarNotaCreditoCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PuedeInsertarCobranzaCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PuedeInsertarCobranzaCliente $parameters
     * @return \StructType\PuedeInsertarCobranzaClienteResponse|bool
     */
    public function PuedeInsertarCobranzaCliente(\StructType\PuedeInsertarCobranzaCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PuedeInsertarCobranzaCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PuedeCancelarCobranzaCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PuedeCancelarCobranzaCliente $parameters
     * @return \StructType\PuedeCancelarCobranzaClienteResponse|bool
     */
    public function PuedeCancelarCobranzaCliente(\StructType\PuedeCancelarCobranzaCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PuedeCancelarCobranzaCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PuedeCancelarCobranzaClienteResponse|\StructType\PuedeCancelarFacturaResponse|\StructType\PuedeCancelarNotaCreditoClienteResponse|\StructType\PuedeInsertarCobranzaClienteResponse|\StructType\PuedeInsertarFacturaResponse|\StructType\PuedeInsertarNotaCreditoClienteResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
