<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Insertar ServiceType
 * @subpackage Services
 */
class Insertar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named InsertarCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertarCliente $parameters
     * @return \StructType\InsertarClienteResponse|bool
     */
    public function InsertarCliente(\StructType\InsertarCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertarCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertarProducto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertarProducto $parameters
     * @return \StructType\InsertarProductoResponse|bool
     */
    public function InsertarProducto(\StructType\InsertarProducto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertarProducto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertarFactura
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertarFactura $parameters
     * @return \StructType\InsertarFacturaResponse|bool
     */
    public function InsertarFactura(\StructType\InsertarFactura $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertarFactura($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertarNotaCreditoCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertarNotaCreditoCliente $parameters
     * @return \StructType\InsertarNotaCreditoClienteResponse|bool
     */
    public function InsertarNotaCreditoCliente(\StructType\InsertarNotaCreditoCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertarNotaCreditoCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertarTipoCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertarTipoCliente $parameters
     * @return \StructType\InsertarTipoClienteResponse|bool
     */
    public function InsertarTipoCliente(\StructType\InsertarTipoCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertarTipoCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertarCiudad
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertarCiudad $parameters
     * @return \StructType\InsertarCiudadResponse|bool
     */
    public function InsertarCiudad(\StructType\InsertarCiudad $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertarCiudad($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertarEstado
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertarEstado $parameters
     * @return \StructType\InsertarEstadoResponse|bool
     */
    public function InsertarEstado(\StructType\InsertarEstado $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertarEstado($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertarPais
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertarPais $parameters
     * @return \StructType\InsertarPaisResponse|bool
     */
    public function InsertarPais(\StructType\InsertarPais $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertarPais($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertarMetodoPago
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertarMetodoPago $parameters
     * @return \StructType\InsertarMetodoPagoResponse|bool
     */
    public function InsertarMetodoPago(\StructType\InsertarMetodoPago $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertarMetodoPago($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertarCondicionesPago
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertarCondicionesPago $parameters
     * @return \StructType\InsertarCondicionesPagoResponse|bool
     */
    public function InsertarCondicionesPago(\StructType\InsertarCondicionesPago $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertarCondicionesPago($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertarIVA
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertarIVA $parameters
     * @return \StructType\InsertarIVAResponse|bool
     */
    public function InsertarIVA(\StructType\InsertarIVA $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertarIVA($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertarBanco
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertarBanco $parameters
     * @return \StructType\InsertarBancoResponse|bool
     */
    public function InsertarBanco(\StructType\InsertarBanco $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertarBanco($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertarCuentaBancaria
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertarCuentaBancaria $parameters
     * @return \StructType\InsertarCuentaBancariaResponse|bool
     */
    public function InsertarCuentaBancaria(\StructType\InsertarCuentaBancaria $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertarCuentaBancaria($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertarRegimenFiscal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertarRegimenFiscal $parameters
     * @return \StructType\InsertarRegimenFiscalResponse|bool
     */
    public function InsertarRegimenFiscal(\StructType\InsertarRegimenFiscal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertarRegimenFiscal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertarCobranzaCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertarCobranzaCliente $parameters
     * @return \StructType\InsertarCobranzaClienteResponse|bool
     */
    public function InsertarCobranzaCliente(\StructType\InsertarCobranzaCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertarCobranzaCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertarTipoProducto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertarTipoProducto $parameters
     * @return \StructType\InsertarTipoProductoResponse|bool
     */
    public function InsertarTipoProducto(\StructType\InsertarTipoProducto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertarTipoProducto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertarSerieFranquicias
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertarSerieFranquicias $parameters
     * @return \StructType\InsertarSerieFranquiciasResponse|bool
     */
    public function InsertarSerieFranquicias(\StructType\InsertarSerieFranquicias $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertarSerieFranquicias($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\InsertarBancoResponse|\StructType\InsertarCiudadResponse|\StructType\InsertarClienteResponse|\StructType\InsertarCobranzaClienteResponse|\StructType\InsertarCondicionesPagoResponse|\StructType\InsertarCuentaBancariaResponse|\StructType\InsertarEstadoResponse|\StructType\InsertarFacturaResponse|\StructType\InsertarIVAResponse|\StructType\InsertarMetodoPagoResponse|\StructType\InsertarNotaCreditoClienteResponse|\StructType\InsertarPaisResponse|\StructType\InsertarProductoResponse|\StructType\InsertarRegimenFiscalResponse|\StructType\InsertarSerieFranquiciasResponse|\StructType\InsertarTipoClienteResponse|\StructType\InsertarTipoProductoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
