<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Estatus ServiceType
 * @subpackage Services
 */
class Estatus extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named EstatusCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EstatusCliente $parameters
     * @return \StructType\EstatusClienteResponse|bool
     */
    public function EstatusCliente(\StructType\EstatusCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EstatusCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EstatusProducto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EstatusProducto $parameters
     * @return \StructType\EstatusProductoResponse|bool
     */
    public function EstatusProducto(\StructType\EstatusProducto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EstatusProducto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EstatusFactura
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EstatusFactura $parameters
     * @return \StructType\EstatusFacturaResponse|bool
     */
    public function EstatusFactura(\StructType\EstatusFactura $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EstatusFactura($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EstatusNotaCreditoCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EstatusNotaCreditoCliente $parameters
     * @return \StructType\EstatusNotaCreditoClienteResponse|bool
     */
    public function EstatusNotaCreditoCliente(\StructType\EstatusNotaCreditoCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EstatusNotaCreditoCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EstatusCobranzaCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EstatusCobranzaCliente $parameters
     * @return \StructType\EstatusCobranzaClienteResponse|bool
     */
    public function EstatusCobranzaCliente(\StructType\EstatusCobranzaCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EstatusCobranzaCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\EstatusClienteResponse|\StructType\EstatusCobranzaClienteResponse|\StructType\EstatusFacturaResponse|\StructType\EstatusNotaCreditoClienteResponse|\StructType\EstatusProductoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
