<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Editar ServiceType
 * @subpackage Services
 */
class Editar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named EditarCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditarCliente $parameters
     * @return \StructType\EditarClienteResponse|bool
     */
    public function EditarCliente(\StructType\EditarCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EditarCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditarTipoCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditarTipoCliente $parameters
     * @return \StructType\EditarTipoClienteResponse|bool
     */
    public function EditarTipoCliente(\StructType\EditarTipoCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EditarTipoCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditarCiudad
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditarCiudad $parameters
     * @return \StructType\EditarCiudadResponse|bool
     */
    public function EditarCiudad(\StructType\EditarCiudad $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EditarCiudad($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditarEstado
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditarEstado $parameters
     * @return \StructType\EditarEstadoResponse|bool
     */
    public function EditarEstado(\StructType\EditarEstado $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EditarEstado($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditarPais
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditarPais $parameters
     * @return \StructType\EditarPaisResponse|bool
     */
    public function EditarPais(\StructType\EditarPais $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EditarPais($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditarMetodoPago
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditarMetodoPago $parameters
     * @return \StructType\EditarMetodoPagoResponse|bool
     */
    public function EditarMetodoPago(\StructType\EditarMetodoPago $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EditarMetodoPago($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditarCondicionesPago
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditarCondicionesPago $parameters
     * @return \StructType\EditarCondicionesPagoResponse|bool
     */
    public function EditarCondicionesPago(\StructType\EditarCondicionesPago $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EditarCondicionesPago($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditarIVA
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditarIVA $parameters
     * @return \StructType\EditarIVAResponse|bool
     */
    public function EditarIVA(\StructType\EditarIVA $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EditarIVA($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditarBanco
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditarBanco $parameters
     * @return \StructType\EditarBancoResponse|bool
     */
    public function EditarBanco(\StructType\EditarBanco $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EditarBanco($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditarCuentaBancaria
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditarCuentaBancaria $parameters
     * @return \StructType\EditarCuentaBancariaResponse|bool
     */
    public function EditarCuentaBancaria(\StructType\EditarCuentaBancaria $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EditarCuentaBancaria($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditarProducto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditarProducto $parameters
     * @return \StructType\EditarProductoResponse|bool
     */
    public function EditarProducto(\StructType\EditarProducto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EditarProducto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditarRegimenFiscal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditarRegimenFiscal $parameters
     * @return \StructType\EditarRegimenFiscalResponse|bool
     */
    public function EditarRegimenFiscal(\StructType\EditarRegimenFiscal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EditarRegimenFiscal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditarTipoProducto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditarTipoProducto $parameters
     * @return \StructType\EditarTipoProductoResponse|bool
     */
    public function EditarTipoProducto(\StructType\EditarTipoProducto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EditarTipoProducto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditarSerieFranquicias
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditarSerieFranquicias $parameters
     * @return \StructType\EditarSerieFranquiciasResponse|bool
     */
    public function EditarSerieFranquicias(\StructType\EditarSerieFranquicias $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EditarSerieFranquicias($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\EditarBancoResponse|\StructType\EditarCiudadResponse|\StructType\EditarClienteResponse|\StructType\EditarCondicionesPagoResponse|\StructType\EditarCuentaBancariaResponse|\StructType\EditarEstadoResponse|\StructType\EditarIVAResponse|\StructType\EditarMetodoPagoResponse|\StructType\EditarPaisResponse|\StructType\EditarProductoResponse|\StructType\EditarRegimenFiscalResponse|\StructType\EditarSerieFranquiciasResponse|\StructType\EditarTipoClienteResponse|\StructType\EditarTipoProductoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
