<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Desencriptar ServiceType
 * @subpackage Services
 */
class Desencriptar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DesencriptarSHA256
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DesencriptarSHA256 $parameters
     * @return \StructType\DesencriptarSHA256Response|bool
     */
    public function DesencriptarSHA256(\StructType\DesencriptarSHA256 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DesencriptarSHA256($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DesencriptarSHA256Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
