<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cancelar ServiceType
 * @subpackage Services
 */
class Cancelar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CancelarFactura
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CancelarFactura $parameters
     * @return \StructType\CancelarFacturaResponse|bool
     */
    public function CancelarFactura(\StructType\CancelarFactura $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CancelarFactura($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CancelarNotaCreditoCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CancelarNotaCreditoCliente $parameters
     * @return \StructType\CancelarNotaCreditoClienteResponse|bool
     */
    public function CancelarNotaCreditoCliente(\StructType\CancelarNotaCreditoCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CancelarNotaCreditoCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CancelarCobranzaCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CancelarCobranzaCliente $parameters
     * @return \StructType\CancelarCobranzaClienteResponse|bool
     */
    public function CancelarCobranzaCliente(\StructType\CancelarCobranzaCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CancelarCobranzaCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CancelarCobranzaClienteResponse|\StructType\CancelarFacturaResponse|\StructType\CancelarNotaCreditoClienteResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
