<?php

namespace GLSTrack;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TuPODResponseType Struct
 * @subpackage Structs
 */
class TuPODResponseType extends AbstractStructBase
{
    /**
     * The ExitCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GLSTrack\GLSExitCode
     */
    public $ExitCode;
    /**
     * The PODFile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PODFile;
    /**
     * The PODFileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PODFileName;
    /**
     * Constructor method for TuPODResponseType
     * @uses TuPODResponseType::setExitCode()
     * @uses TuPODResponseType::setPODFile()
     * @uses TuPODResponseType::setPODFileName()
     * @param \GLSTrack\GLSExitCode $exitCode
     * @param string $pODFile
     * @param string $pODFileName
     */
    public function __construct(\GLSTrack\GLSExitCode $exitCode = null, $pODFile = null, $pODFileName = null)
    {
        $this
            ->setExitCode($exitCode)
            ->setPODFile($pODFile)
            ->setPODFileName($pODFileName);
    }
    /**
     * Get ExitCode value
     * @return \GLSTrack\GLSExitCode
     */
    public function getExitCode()
    {
        return $this->ExitCode;
    }
    /**
     * Set ExitCode value
     * @param \GLSTrack\GLSExitCode $exitCode
     * @return \GLSTrack\TuPODResponseType
     */
    public function setExitCode(\GLSTrack\GLSExitCode $exitCode = null)
    {
        $this->ExitCode = $exitCode;
        return $this;
    }
    /**
     * Get PODFile value
     * @return string
     */
    public function getPODFile()
    {
        return $this->PODFile;
    }
    /**
     * Set PODFile value
     * @param string $pODFile
     * @return \GLSTrack\TuPODResponseType
     */
    public function setPODFile($pODFile = null)
    {
        // validation for constraint: string
        if (!is_null($pODFile) && !is_string($pODFile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pODFile, true), gettype($pODFile)), __LINE__);
        }
        $this->PODFile = $pODFile;
        return $this;
    }
    /**
     * Get PODFileName value
     * @return string
     */
    public function getPODFileName()
    {
        return $this->PODFileName;
    }
    /**
     * Set PODFileName value
     * @param string $pODFileName
     * @return \GLSTrack\TuPODResponseType
     */
    public function setPODFileName($pODFileName = null)
    {
        // validation for constraint: string
        if (!is_null($pODFileName) && !is_string($pODFileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pODFileName, true), gettype($pODFileName)), __LINE__);
        }
        $this->PODFileName = $pODFileName;
        return $this;
    }
}
