<?php

namespace GLSTrack;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GLSCustomerReference Struct
 * @subpackage Structs
 */
class GLSCustomerReference extends AbstractStructBase
{
    /**
     * The ReferenceType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ReferenceType;
    /**
     * The ReferenceValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ReferenceValue;
    /**
     * Constructor method for GLSCustomerReference
     * @uses GLSCustomerReference::setReferenceType()
     * @uses GLSCustomerReference::setReferenceValue()
     * @param string $referenceType
     * @param string $referenceValue
     */
    public function __construct($referenceType = null, $referenceValue = null)
    {
        $this
            ->setReferenceType($referenceType)
            ->setReferenceValue($referenceValue);
    }
    /**
     * Get ReferenceType value
     * @return string
     */
    public function getReferenceType()
    {
        return $this->ReferenceType;
    }
    /**
     * Set ReferenceType value
     * @param string $referenceType
     * @return \GLSTrack\GLSCustomerReference
     */
    public function setReferenceType($referenceType = null)
    {
        // validation for constraint: string
        if (!is_null($referenceType) && !is_string($referenceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceType, true), gettype($referenceType)), __LINE__);
        }
        $this->ReferenceType = $referenceType;
        return $this;
    }
    /**
     * Get ReferenceValue value
     * @return string
     */
    public function getReferenceValue()
    {
        return $this->ReferenceValue;
    }
    /**
     * Set ReferenceValue value
     * @param string $referenceValue
     * @return \GLSTrack\GLSCustomerReference
     */
    public function setReferenceValue($referenceValue = null)
    {
        // validation for constraint: string
        if (!is_null($referenceValue) && !is_string($referenceValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceValue, true), gettype($referenceValue)), __LINE__);
        }
        $this->ReferenceValue = $referenceValue;
        return $this;
    }
}
