<?php

namespace GLSTrack;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for List Service
 * @subpackage Services
 */
class _List extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetTuList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLSTrack\TuListRequestType $getTuListRequest
     * @return \GLSTrack\TuListResponseType|bool
     */
    public function GetTuList(\GLSTrack\TuListRequestType $getTuListRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTuList($getTuListRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GLSTrack\TuListResponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
