<?php

namespace GLSTrack;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TuListRequestType Struct
 * @subpackage Structs
 */
class TuListRequestType extends AbstractStructBase
{
    /**
     * The Credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GLSTrack\GLSUserCredentials
     */
    public $Credentials;
    /**
     * The RefValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RefValue;
    /**
     * The DateFrom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \GLSTrack\GLSDateTime
     */
    public $DateFrom;
    /**
     * The DateTo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \GLSTrack\GLSDateTime
     */
    public $DateTo;
    /**
     * The CustomRef
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomRef;
    /**
     * The Parameters
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \GLSTrack\GLSParameters[]
     */
    public $Parameters;
    /**
     * Constructor method for TuListRequestType
     * @uses TuListRequestType::setCredentials()
     * @uses TuListRequestType::setRefValue()
     * @uses TuListRequestType::setDateFrom()
     * @uses TuListRequestType::setDateTo()
     * @uses TuListRequestType::setCustomRef()
     * @uses TuListRequestType::setParameters()
     * @param \GLSTrack\GLSUserCredentials $credentials
     * @param string $refValue
     * @param \GLSTrack\GLSDateTime $dateFrom
     * @param \GLSTrack\GLSDateTime $dateTo
     * @param string $customRef
     * @param \GLSTrack\GLSParameters[] $parameters
     */
    public function __construct(\GLSTrack\GLSUserCredentials $credentials = null, $refValue = null, \GLSTrack\GLSDateTime $dateFrom = null, \GLSTrack\GLSDateTime $dateTo = null, $customRef = null, array $parameters = array())
    {
        $this
            ->setCredentials($credentials)
            ->setRefValue($refValue)
            ->setDateFrom($dateFrom)
            ->setDateTo($dateTo)
            ->setCustomRef($customRef)
            ->setParameters($parameters);
    }
    /**
     * Get Credentials value
     * @return \GLSTrack\GLSUserCredentials
     */
    public function getCredentials()
    {
        return $this->Credentials;
    }
    /**
     * Set Credentials value
     * @param \GLSTrack\GLSUserCredentials $credentials
     * @return \GLSTrack\TuListRequestType
     */
    public function setCredentials(\GLSTrack\GLSUserCredentials $credentials = null)
    {
        $this->Credentials = $credentials;
        return $this;
    }
    /**
     * Get RefValue value
     * @return string|null
     */
    public function getRefValue()
    {
        return $this->RefValue;
    }
    /**
     * Set RefValue value
     * @param string $refValue
     * @return \GLSTrack\TuListRequestType
     */
    public function setRefValue($refValue = null)
    {
        // validation for constraint: string
        if (!is_null($refValue) && !is_string($refValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refValue, true), gettype($refValue)), __LINE__);
        }
        $this->RefValue = $refValue;
        return $this;
    }
    /**
     * Get DateFrom value
     * @return \GLSTrack\GLSDateTime|null
     */
    public function getDateFrom()
    {
        return $this->DateFrom;
    }
    /**
     * Set DateFrom value
     * @param \GLSTrack\GLSDateTime $dateFrom
     * @return \GLSTrack\TuListRequestType
     */
    public function setDateFrom(\GLSTrack\GLSDateTime $dateFrom = null)
    {
        $this->DateFrom = $dateFrom;
        return $this;
    }
    /**
     * Get DateTo value
     * @return \GLSTrack\GLSDateTime|null
     */
    public function getDateTo()
    {
        return $this->DateTo;
    }
    /**
     * Set DateTo value
     * @param \GLSTrack\GLSDateTime $dateTo
     * @return \GLSTrack\TuListRequestType
     */
    public function setDateTo(\GLSTrack\GLSDateTime $dateTo = null)
    {
        $this->DateTo = $dateTo;
        return $this;
    }
    /**
     * Get CustomRef value
     * @return string|null
     */
    public function getCustomRef()
    {
        return $this->CustomRef;
    }
    /**
     * Set CustomRef value
     * @param string $customRef
     * @return \GLSTrack\TuListRequestType
     */
    public function setCustomRef($customRef = null)
    {
        // validation for constraint: string
        if (!is_null($customRef) && !is_string($customRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customRef, true), gettype($customRef)), __LINE__);
        }
        $this->CustomRef = $customRef;
        return $this;
    }
    /**
     * Get Parameters value
     * @return \GLSTrack\GLSParameters[]|null
     */
    public function getParameters()
    {
        return $this->Parameters;
    }
    /**
     * This method is responsible for validating the values passed to the setParameters method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParameters method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateParametersForArrayConstraintsFromSetParameters(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tuListRequestTypeParametersItem) {
            // validation for constraint: itemType
            if (!$tuListRequestTypeParametersItem instanceof \GLSTrack\GLSParameters) {
                $invalidValues[] = is_object($tuListRequestTypeParametersItem) ? get_class($tuListRequestTypeParametersItem) : sprintf('%s(%s)', gettype($tuListRequestTypeParametersItem), var_export($tuListRequestTypeParametersItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Parameters property can only contain items of type \GLSTrack\GLSParameters, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Parameters value
     * @throws \InvalidArgumentException
     * @param \GLSTrack\GLSParameters[] $parameters
     * @return \GLSTrack\TuListRequestType
     */
    public function setParameters(array $parameters = array())
    {
        // validation for constraint: array
        if ('' !== ($parametersArrayErrorMessage = self::validateParametersForArrayConstraintsFromSetParameters($parameters))) {
            throw new \InvalidArgumentException($parametersArrayErrorMessage, __LINE__);
        }
        $this->Parameters = $parameters;
        return $this;
    }
    /**
     * Add item to Parameters value
     * @throws \InvalidArgumentException
     * @param \GLSTrack\GLSParameters $item
     * @return \GLSTrack\TuListRequestType
     */
    public function addToParameters(\GLSTrack\GLSParameters $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GLSTrack\GLSParameters) {
            throw new \InvalidArgumentException(sprintf('The Parameters property can only contain items of type \GLSTrack\GLSParameters, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Parameters[] = $item;
        return $this;
    }
}
