<?php

namespace GLSTrack;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for POD Service
 * @subpackage Services
 */
class POD extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetTuPOD
     * Meta information extracted from the WSDL
     * - documentation: Method to extract the signature of a POD. The result will contain original filename <PODFileName /> and a <PODFile /> that is the binary file encoded in BASE64
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLSTrack\TuPODRequestType $getTuPODRequest
     * @return \GLSTrack\TuPODResponseType|bool
     */
    public function GetTuPOD(\GLSTrack\TuPODRequestType $getTuPODRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTuPOD($getTuPODRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GLSTrack\TuPODResponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
