<?php

namespace GLSTrack;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Details Service
 * @subpackage Services
 */
class Details extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetTusDetails
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLSTrack\TusDetailsRequestType $getTusDetailsRequest
     * @return \GLSTrack\TusDetailsReponseType|bool
     */
    public function GetTusDetails(\GLSTrack\TusDetailsRequestType $getTusDetailsRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTusDetails($getTusDetailsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GLSTrack\TusDetailsReponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
