<?php

namespace GLSTrack;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Detail Service
 * @subpackage Services
 */
class Detail extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetTuDetail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLSTrack\TuDetailsRequestType $getTuDetailRequest
     * @return \GLSTrack\TuDetailsResponseType|bool
     */
    public function GetTuDetail(\GLSTrack\TuDetailsRequestType $getTuDetailRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTuDetail($getTuDetailRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GLSTrack\TuDetailsResponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
