<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://www.gls-group.eu/276-I-PORTAL-WEBSERVICE/services/Tracking/wsdl/Tracking.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://www.gls-group.eu/276-I-PORTAL-WEBSERVICE/services/Tracking/wsdl/Tracking.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \GLSTrack\ClassMap::get(),
);
/**
 * Samples for Detail ServiceType
 */
$detail = new \GLSTrack\Detail($options);
/**
 * Sample call for GetTuDetail operation/method
 */
if ($detail->GetTuDetail(new \GLSTrack\TuDetailsRequestType()) !== false) {
    print_r($detail->getResult());
} else {
    print_r($detail->getLastError());
}
/**
 * Samples for List ServiceType
 */
$list = new \GLSTrack\_List($options);
/**
 * Sample call for GetTuList operation/method
 */
if ($list->GetTuList(new \GLSTrack\TuListRequestType()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Samples for POD ServiceType
 */
$pOD = new \GLSTrack\POD($options);
/**
 * Sample call for GetTuPOD operation/method
 */
if ($pOD->GetTuPOD(new \GLSTrack\TuPODRequestType()) !== false) {
    print_r($pOD->getResult());
} else {
    print_r($pOD->getLastError());
}
/**
 * Samples for Details ServiceType
 */
$details = new \GLSTrack\Details($options);
/**
 * Sample call for GetTusDetails operation/method
 */
if ($details->GetTusDetails(new \GLSTrack\TusDetailsRequestType()) !== false) {
    print_r($details->getResult());
} else {
    print_r($details->getLastError());
}
