<?php

namespace GLSTrack;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TusDetailsRequestType Struct
 * @subpackage Structs
 */
class TusDetailsRequestType extends AbstractStructBase
{
    /**
     * The RefValues
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 1
     * @var string[]
     */
    public $RefValues;
    /**
     * The Credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GLSTrack\GLSUserCredentials
     */
    public $Credentials;
    /**
     * The Parameters
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \GLSTrack\GLSParameters[]
     */
    public $Parameters;
    /**
     * Constructor method for TusDetailsRequestType
     * @uses TusDetailsRequestType::setRefValues()
     * @uses TusDetailsRequestType::setCredentials()
     * @uses TusDetailsRequestType::setParameters()
     * @param string[] $refValues
     * @param \GLSTrack\GLSUserCredentials $credentials
     * @param \GLSTrack\GLSParameters[] $parameters
     */
    public function __construct(array $refValues = array(), \GLSTrack\GLSUserCredentials $credentials = null, array $parameters = array())
    {
        $this
            ->setRefValues($refValues)
            ->setCredentials($credentials)
            ->setParameters($parameters);
    }
    /**
     * Get RefValues value
     * @return string[]
     */
    public function getRefValues()
    {
        return $this->RefValues;
    }
    /**
     * This method is responsible for validating the values passed to the setRefValues method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRefValues method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRefValuesForArrayConstraintsFromSetRefValues(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tusDetailsRequestTypeRefValuesItem) {
            // validation for constraint: itemType
            if (!is_string($tusDetailsRequestTypeRefValuesItem)) {
                $invalidValues[] = is_object($tusDetailsRequestTypeRefValuesItem) ? get_class($tusDetailsRequestTypeRefValuesItem) : sprintf('%s(%s)', gettype($tusDetailsRequestTypeRefValuesItem), var_export($tusDetailsRequestTypeRefValuesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RefValues property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RefValues value
     * @throws \InvalidArgumentException
     * @param string[] $refValues
     * @return \GLSTrack\TusDetailsRequestType
     */
    public function setRefValues(array $refValues = array())
    {
        // validation for constraint: array
        if ('' !== ($refValuesArrayErrorMessage = self::validateRefValuesForArrayConstraintsFromSetRefValues($refValues))) {
            throw new \InvalidArgumentException($refValuesArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($refValues) && count($refValues) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($refValues)), __LINE__);
        }
        $this->RefValues = $refValues;
        return $this;
    }
    /**
     * Add item to RefValues value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \GLSTrack\TusDetailsRequestType
     */
    public function addToRefValues($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The RefValues property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->RefValues) && count($this->RefValues) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->RefValues)), __LINE__);
        }
        $this->RefValues[] = $item;
        return $this;
    }
    /**
     * Get Credentials value
     * @return \GLSTrack\GLSUserCredentials
     */
    public function getCredentials()
    {
        return $this->Credentials;
    }
    /**
     * Set Credentials value
     * @param \GLSTrack\GLSUserCredentials $credentials
     * @return \GLSTrack\TusDetailsRequestType
     */
    public function setCredentials(\GLSTrack\GLSUserCredentials $credentials = null)
    {
        $this->Credentials = $credentials;
        return $this;
    }
    /**
     * Get Parameters value
     * @return \GLSTrack\GLSParameters[]|null
     */
    public function getParameters()
    {
        return $this->Parameters;
    }
    /**
     * This method is responsible for validating the values passed to the setParameters method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParameters method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateParametersForArrayConstraintsFromSetParameters(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tusDetailsRequestTypeParametersItem) {
            // validation for constraint: itemType
            if (!$tusDetailsRequestTypeParametersItem instanceof \GLSTrack\GLSParameters) {
                $invalidValues[] = is_object($tusDetailsRequestTypeParametersItem) ? get_class($tusDetailsRequestTypeParametersItem) : sprintf('%s(%s)', gettype($tusDetailsRequestTypeParametersItem), var_export($tusDetailsRequestTypeParametersItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Parameters property can only contain items of type \GLSTrack\GLSParameters, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Parameters value
     * @throws \InvalidArgumentException
     * @param \GLSTrack\GLSParameters[] $parameters
     * @return \GLSTrack\TusDetailsRequestType
     */
    public function setParameters(array $parameters = array())
    {
        // validation for constraint: array
        if ('' !== ($parametersArrayErrorMessage = self::validateParametersForArrayConstraintsFromSetParameters($parameters))) {
            throw new \InvalidArgumentException($parametersArrayErrorMessage, __LINE__);
        }
        $this->Parameters = $parameters;
        return $this;
    }
    /**
     * Add item to Parameters value
     * @throws \InvalidArgumentException
     * @param \GLSTrack\GLSParameters $item
     * @return \GLSTrack\TusDetailsRequestType
     */
    public function addToParameters(\GLSTrack\GLSParameters $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GLSTrack\GLSParameters) {
            throw new \InvalidArgumentException(sprintf('The Parameters property can only contain items of type \GLSTrack\GLSParameters, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Parameters[] = $item;
        return $this;
    }
}
