<?php

namespace GLSTrack;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TuPODRequestType Struct
 * @subpackage Structs
 */
class TuPODRequestType extends AbstractStructBase
{
    /**
     * The Credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GLSTrack\GLSUserCredentials
     */
    public $Credentials;
    /**
     * The RefValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RefValue;
    /**
     * The Parameters
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \GLSTrack\GLSParameters[]
     */
    public $Parameters;
    /**
     * Constructor method for TuPODRequestType
     * @uses TuPODRequestType::setCredentials()
     * @uses TuPODRequestType::setRefValue()
     * @uses TuPODRequestType::setParameters()
     * @param \GLSTrack\GLSUserCredentials $credentials
     * @param string $refValue
     * @param \GLSTrack\GLSParameters[] $parameters
     */
    public function __construct(\GLSTrack\GLSUserCredentials $credentials = null, $refValue = null, array $parameters = array())
    {
        $this
            ->setCredentials($credentials)
            ->setRefValue($refValue)
            ->setParameters($parameters);
    }
    /**
     * Get Credentials value
     * @return \GLSTrack\GLSUserCredentials
     */
    public function getCredentials()
    {
        return $this->Credentials;
    }
    /**
     * Set Credentials value
     * @param \GLSTrack\GLSUserCredentials $credentials
     * @return \GLSTrack\TuPODRequestType
     */
    public function setCredentials(\GLSTrack\GLSUserCredentials $credentials = null)
    {
        $this->Credentials = $credentials;
        return $this;
    }
    /**
     * Get RefValue value
     * @return string
     */
    public function getRefValue()
    {
        return $this->RefValue;
    }
    /**
     * Set RefValue value
     * @param string $refValue
     * @return \GLSTrack\TuPODRequestType
     */
    public function setRefValue($refValue = null)
    {
        // validation for constraint: string
        if (!is_null($refValue) && !is_string($refValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refValue, true), gettype($refValue)), __LINE__);
        }
        $this->RefValue = $refValue;
        return $this;
    }
    /**
     * Get Parameters value
     * @return \GLSTrack\GLSParameters[]|null
     */
    public function getParameters()
    {
        return $this->Parameters;
    }
    /**
     * This method is responsible for validating the values passed to the setParameters method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParameters method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateParametersForArrayConstraintsFromSetParameters(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tuPODRequestTypeParametersItem) {
            // validation for constraint: itemType
            if (!$tuPODRequestTypeParametersItem instanceof \GLSTrack\GLSParameters) {
                $invalidValues[] = is_object($tuPODRequestTypeParametersItem) ? get_class($tuPODRequestTypeParametersItem) : sprintf('%s(%s)', gettype($tuPODRequestTypeParametersItem), var_export($tuPODRequestTypeParametersItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Parameters property can only contain items of type \GLSTrack\GLSParameters, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Parameters value
     * @throws \InvalidArgumentException
     * @param \GLSTrack\GLSParameters[] $parameters
     * @return \GLSTrack\TuPODRequestType
     */
    public function setParameters(array $parameters = array())
    {
        // validation for constraint: array
        if ('' !== ($parametersArrayErrorMessage = self::validateParametersForArrayConstraintsFromSetParameters($parameters))) {
            throw new \InvalidArgumentException($parametersArrayErrorMessage, __LINE__);
        }
        $this->Parameters = $parameters;
        return $this;
    }
    /**
     * Add item to Parameters value
     * @throws \InvalidArgumentException
     * @param \GLSTrack\GLSParameters $item
     * @return \GLSTrack\TuPODRequestType
     */
    public function addToParameters(\GLSTrack\GLSParameters $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GLSTrack\GLSParameters) {
            throw new \InvalidArgumentException(sprintf('The Parameters property can only contain items of type \GLSTrack\GLSParameters, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Parameters[] = $item;
        return $this;
    }
}
