<?php

namespace GLSTrack;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TuDetailsResponseType Struct
 * @subpackage Structs
 */
class TuDetailsResponseType extends AbstractStructBase
{
    /**
     * The ExitCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GLSTrack\GLSExitCode
     */
    public $ExitCode;
    /**
     * The TuNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TuNo;
    /**
     * The NationalRef
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $NationalRef;
    /**
     * The ConsigneeAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GLSTrack\GLSAddress
     */
    public $ConsigneeAddress;
    /**
     * The ShipperAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GLSTrack\GLSAddress
     */
    public $ShipperAddress;
    /**
     * The RequesterAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GLSTrack\GLSAddress
     */
    public $RequesterAddress;
    /**
     * The DeliveryDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GLSTrack\GLSDateTime
     */
    public $DeliveryDateTime;
    /**
     * The PickupDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GLSTrack\GLSDateTime
     */
    public $PickupDateTime;
    /**
     * The Product
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Product;
    /**
     * The TuWeight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TuWeight;
    /**
     * The Services
     * Meta information extracted from the WSDL
     * - maxOccurs: 100
     * - minOccurs: 0
     * @var string[]
     */
    public $Services;
    /**
     * The CustomerReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \GLSTrack\GLSCustomerReference[]
     */
    public $CustomerReference;
    /**
     * The History
     * Meta information extracted from the WSDL
     * - maxOccurs: 1000
     * - minOccurs: 0
     * @var \GLSTrack\GLSEvent[]
     */
    public $History;
    /**
     * The Signature
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Signature;
    /**
     * Constructor method for TuDetailsResponseType
     * @uses TuDetailsResponseType::setExitCode()
     * @uses TuDetailsResponseType::setTuNo()
     * @uses TuDetailsResponseType::setNationalRef()
     * @uses TuDetailsResponseType::setConsigneeAddress()
     * @uses TuDetailsResponseType::setShipperAddress()
     * @uses TuDetailsResponseType::setRequesterAddress()
     * @uses TuDetailsResponseType::setDeliveryDateTime()
     * @uses TuDetailsResponseType::setPickupDateTime()
     * @uses TuDetailsResponseType::setProduct()
     * @uses TuDetailsResponseType::setTuWeight()
     * @uses TuDetailsResponseType::setServices()
     * @uses TuDetailsResponseType::setCustomerReference()
     * @uses TuDetailsResponseType::setHistory()
     * @uses TuDetailsResponseType::setSignature()
     * @param \GLSTrack\GLSExitCode $exitCode
     * @param string $tuNo
     * @param string $nationalRef
     * @param \GLSTrack\GLSAddress $consigneeAddress
     * @param \GLSTrack\GLSAddress $shipperAddress
     * @param \GLSTrack\GLSAddress $requesterAddress
     * @param \GLSTrack\GLSDateTime $deliveryDateTime
     * @param \GLSTrack\GLSDateTime $pickupDateTime
     * @param string $product
     * @param float $tuWeight
     * @param string[] $services
     * @param \GLSTrack\GLSCustomerReference[] $customerReference
     * @param \GLSTrack\GLSEvent[] $history
     * @param string $signature
     */
    public function __construct(\GLSTrack\GLSExitCode $exitCode = null, $tuNo = null, $nationalRef = null, \GLSTrack\GLSAddress $consigneeAddress = null, \GLSTrack\GLSAddress $shipperAddress = null, \GLSTrack\GLSAddress $requesterAddress = null, \GLSTrack\GLSDateTime $deliveryDateTime = null, \GLSTrack\GLSDateTime $pickupDateTime = null, $product = null, $tuWeight = null, array $services = array(), array $customerReference = array(), array $history = array(), $signature = null)
    {
        $this
            ->setExitCode($exitCode)
            ->setTuNo($tuNo)
            ->setNationalRef($nationalRef)
            ->setConsigneeAddress($consigneeAddress)
            ->setShipperAddress($shipperAddress)
            ->setRequesterAddress($requesterAddress)
            ->setDeliveryDateTime($deliveryDateTime)
            ->setPickupDateTime($pickupDateTime)
            ->setProduct($product)
            ->setTuWeight($tuWeight)
            ->setServices($services)
            ->setCustomerReference($customerReference)
            ->setHistory($history)
            ->setSignature($signature);
    }
    /**
     * Get ExitCode value
     * @return \GLSTrack\GLSExitCode
     */
    public function getExitCode()
    {
        return $this->ExitCode;
    }
    /**
     * Set ExitCode value
     * @param \GLSTrack\GLSExitCode $exitCode
     * @return \GLSTrack\TuDetailsResponseType
     */
    public function setExitCode(\GLSTrack\GLSExitCode $exitCode = null)
    {
        $this->ExitCode = $exitCode;
        return $this;
    }
    /**
     * Get TuNo value
     * @return string
     */
    public function getTuNo()
    {
        return $this->TuNo;
    }
    /**
     * Set TuNo value
     * @param string $tuNo
     * @return \GLSTrack\TuDetailsResponseType
     */
    public function setTuNo($tuNo = null)
    {
        // validation for constraint: string
        if (!is_null($tuNo) && !is_string($tuNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tuNo, true), gettype($tuNo)), __LINE__);
        }
        $this->TuNo = $tuNo;
        return $this;
    }
    /**
     * Get NationalRef value
     * @return string
     */
    public function getNationalRef()
    {
        return $this->NationalRef;
    }
    /**
     * Set NationalRef value
     * @param string $nationalRef
     * @return \GLSTrack\TuDetailsResponseType
     */
    public function setNationalRef($nationalRef = null)
    {
        // validation for constraint: string
        if (!is_null($nationalRef) && !is_string($nationalRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nationalRef, true), gettype($nationalRef)), __LINE__);
        }
        $this->NationalRef = $nationalRef;
        return $this;
    }
    /**
     * Get ConsigneeAddress value
     * @return \GLSTrack\GLSAddress
     */
    public function getConsigneeAddress()
    {
        return $this->ConsigneeAddress;
    }
    /**
     * Set ConsigneeAddress value
     * @param \GLSTrack\GLSAddress $consigneeAddress
     * @return \GLSTrack\TuDetailsResponseType
     */
    public function setConsigneeAddress(\GLSTrack\GLSAddress $consigneeAddress = null)
    {
        $this->ConsigneeAddress = $consigneeAddress;
        return $this;
    }
    /**
     * Get ShipperAddress value
     * @return \GLSTrack\GLSAddress
     */
    public function getShipperAddress()
    {
        return $this->ShipperAddress;
    }
    /**
     * Set ShipperAddress value
     * @param \GLSTrack\GLSAddress $shipperAddress
     * @return \GLSTrack\TuDetailsResponseType
     */
    public function setShipperAddress(\GLSTrack\GLSAddress $shipperAddress = null)
    {
        $this->ShipperAddress = $shipperAddress;
        return $this;
    }
    /**
     * Get RequesterAddress value
     * @return \GLSTrack\GLSAddress
     */
    public function getRequesterAddress()
    {
        return $this->RequesterAddress;
    }
    /**
     * Set RequesterAddress value
     * @param \GLSTrack\GLSAddress $requesterAddress
     * @return \GLSTrack\TuDetailsResponseType
     */
    public function setRequesterAddress(\GLSTrack\GLSAddress $requesterAddress = null)
    {
        $this->RequesterAddress = $requesterAddress;
        return $this;
    }
    /**
     * Get DeliveryDateTime value
     * @return \GLSTrack\GLSDateTime
     */
    public function getDeliveryDateTime()
    {
        return $this->DeliveryDateTime;
    }
    /**
     * Set DeliveryDateTime value
     * @param \GLSTrack\GLSDateTime $deliveryDateTime
     * @return \GLSTrack\TuDetailsResponseType
     */
    public function setDeliveryDateTime(\GLSTrack\GLSDateTime $deliveryDateTime = null)
    {
        $this->DeliveryDateTime = $deliveryDateTime;
        return $this;
    }
    /**
     * Get PickupDateTime value
     * @return \GLSTrack\GLSDateTime
     */
    public function getPickupDateTime()
    {
        return $this->PickupDateTime;
    }
    /**
     * Set PickupDateTime value
     * @param \GLSTrack\GLSDateTime $pickupDateTime
     * @return \GLSTrack\TuDetailsResponseType
     */
    public function setPickupDateTime(\GLSTrack\GLSDateTime $pickupDateTime = null)
    {
        $this->PickupDateTime = $pickupDateTime;
        return $this;
    }
    /**
     * Get Product value
     * @return string
     */
    public function getProduct()
    {
        return $this->Product;
    }
    /**
     * Set Product value
     * @param string $product
     * @return \GLSTrack\TuDetailsResponseType
     */
    public function setProduct($product = null)
    {
        // validation for constraint: string
        if (!is_null($product) && !is_string($product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($product, true), gettype($product)), __LINE__);
        }
        $this->Product = $product;
        return $this;
    }
    /**
     * Get TuWeight value
     * @return float
     */
    public function getTuWeight()
    {
        return $this->TuWeight;
    }
    /**
     * Set TuWeight value
     * @param float $tuWeight
     * @return \GLSTrack\TuDetailsResponseType
     */
    public function setTuWeight($tuWeight = null)
    {
        // validation for constraint: float
        if (!is_null($tuWeight) && !(is_float($tuWeight) || is_numeric($tuWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tuWeight, true), gettype($tuWeight)), __LINE__);
        }
        $this->TuWeight = $tuWeight;
        return $this;
    }
    /**
     * Get Services value
     * @return string[]|null
     */
    public function getServices()
    {
        return $this->Services;
    }
    /**
     * This method is responsible for validating the values passed to the setServices method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServices method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServicesForArrayConstraintsFromSetServices(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tuDetailsResponseTypeServicesItem) {
            // validation for constraint: itemType
            if (!is_string($tuDetailsResponseTypeServicesItem)) {
                $invalidValues[] = is_object($tuDetailsResponseTypeServicesItem) ? get_class($tuDetailsResponseTypeServicesItem) : sprintf('%s(%s)', gettype($tuDetailsResponseTypeServicesItem), var_export($tuDetailsResponseTypeServicesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Services property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Services value
     * @throws \InvalidArgumentException
     * @param string[] $services
     * @return \GLSTrack\TuDetailsResponseType
     */
    public function setServices(array $services = array())
    {
        // validation for constraint: array
        if ('' !== ($servicesArrayErrorMessage = self::validateServicesForArrayConstraintsFromSetServices($services))) {
            throw new \InvalidArgumentException($servicesArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(100)
        if (is_array($services) && count($services) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 100', count($services)), __LINE__);
        }
        $this->Services = $services;
        return $this;
    }
    /**
     * Add item to Services value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \GLSTrack\TuDetailsResponseType
     */
    public function addToServices($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Services property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(100)
        if (is_array($this->Services) && count($this->Services) >= 100) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 100', count($this->Services)), __LINE__);
        }
        $this->Services[] = $item;
        return $this;
    }
    /**
     * Get CustomerReference value
     * @return \GLSTrack\GLSCustomerReference[]|null
     */
    public function getCustomerReference()
    {
        return $this->CustomerReference;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomerReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomerReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomerReferenceForArrayConstraintsFromSetCustomerReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tuDetailsResponseTypeCustomerReferenceItem) {
            // validation for constraint: itemType
            if (!$tuDetailsResponseTypeCustomerReferenceItem instanceof \GLSTrack\GLSCustomerReference) {
                $invalidValues[] = is_object($tuDetailsResponseTypeCustomerReferenceItem) ? get_class($tuDetailsResponseTypeCustomerReferenceItem) : sprintf('%s(%s)', gettype($tuDetailsResponseTypeCustomerReferenceItem), var_export($tuDetailsResponseTypeCustomerReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustomerReference property can only contain items of type \GLSTrack\GLSCustomerReference, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustomerReference value
     * @throws \InvalidArgumentException
     * @param \GLSTrack\GLSCustomerReference[] $customerReference
     * @return \GLSTrack\TuDetailsResponseType
     */
    public function setCustomerReference(array $customerReference = array())
    {
        // validation for constraint: array
        if ('' !== ($customerReferenceArrayErrorMessage = self::validateCustomerReferenceForArrayConstraintsFromSetCustomerReference($customerReference))) {
            throw new \InvalidArgumentException($customerReferenceArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($customerReference) && count($customerReference) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($customerReference)), __LINE__);
        }
        $this->CustomerReference = $customerReference;
        return $this;
    }
    /**
     * Add item to CustomerReference value
     * @throws \InvalidArgumentException
     * @param \GLSTrack\GLSCustomerReference $item
     * @return \GLSTrack\TuDetailsResponseType
     */
    public function addToCustomerReference(\GLSTrack\GLSCustomerReference $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GLSTrack\GLSCustomerReference) {
            throw new \InvalidArgumentException(sprintf('The CustomerReference property can only contain items of type \GLSTrack\GLSCustomerReference, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->CustomerReference) && count($this->CustomerReference) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->CustomerReference)), __LINE__);
        }
        $this->CustomerReference[] = $item;
        return $this;
    }
    /**
     * Get History value
     * @return \GLSTrack\GLSEvent[]|null
     */
    public function getHistory()
    {
        return $this->History;
    }
    /**
     * This method is responsible for validating the values passed to the setHistory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHistory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHistoryForArrayConstraintsFromSetHistory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tuDetailsResponseTypeHistoryItem) {
            // validation for constraint: itemType
            if (!$tuDetailsResponseTypeHistoryItem instanceof \GLSTrack\GLSEvent) {
                $invalidValues[] = is_object($tuDetailsResponseTypeHistoryItem) ? get_class($tuDetailsResponseTypeHistoryItem) : sprintf('%s(%s)', gettype($tuDetailsResponseTypeHistoryItem), var_export($tuDetailsResponseTypeHistoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The History property can only contain items of type \GLSTrack\GLSEvent, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set History value
     * @throws \InvalidArgumentException
     * @param \GLSTrack\GLSEvent[] $history
     * @return \GLSTrack\TuDetailsResponseType
     */
    public function setHistory(array $history = array())
    {
        // validation for constraint: array
        if ('' !== ($historyArrayErrorMessage = self::validateHistoryForArrayConstraintsFromSetHistory($history))) {
            throw new \InvalidArgumentException($historyArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(1000)
        if (is_array($history) && count($history) > 1000) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 1000', count($history)), __LINE__);
        }
        $this->History = $history;
        return $this;
    }
    /**
     * Add item to History value
     * @throws \InvalidArgumentException
     * @param \GLSTrack\GLSEvent $item
     * @return \GLSTrack\TuDetailsResponseType
     */
    public function addToHistory(\GLSTrack\GLSEvent $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GLSTrack\GLSEvent) {
            throw new \InvalidArgumentException(sprintf('The History property can only contain items of type \GLSTrack\GLSEvent, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(1000)
        if (is_array($this->History) && count($this->History) >= 1000) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 1000', count($this->History)), __LINE__);
        }
        $this->History[] = $item;
        return $this;
    }
    /**
     * Get Signature value
     * @return string|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @param string $signature
     * @return \GLSTrack\TuDetailsResponseType
     */
    public function setSignature($signature = null)
    {
        // validation for constraint: string
        if (!is_null($signature) && !is_string($signature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($signature, true), gettype($signature)), __LINE__);
        }
        $this->Signature = $signature;
        return $this;
    }
}
