<?php

namespace GLS;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cServiceIDENT Struct
 * @subpackage Structs
 */
class CServiceIDENT extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $name;
    /**
     * The country
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $country;
    /**
     * The zipcode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $zipcode;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $city;
    /**
     * The street
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $street;
    /**
     * The date_birth
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $date_birth;
    /**
     * The identity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $identity;
    /**
     * The ident_doctype
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $ident_doctype;
    /**
     * The nation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $nation;
    /**
     * The national_idnum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $national_idnum;
    /**
     * The spages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $spages;
    /**
     * The ssign
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $ssign;
    /**
     * The sdealsend
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $sdealsend;
    /**
     * The sdealrec
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $sdealrec;
    /**
     * Constructor method for cServiceIDENT
     * @uses CServiceIDENT::setName()
     * @uses CServiceIDENT::setCountry()
     * @uses CServiceIDENT::setZipcode()
     * @uses CServiceIDENT::setCity()
     * @uses CServiceIDENT::setStreet()
     * @uses CServiceIDENT::setDate_birth()
     * @uses CServiceIDENT::setIdentity()
     * @uses CServiceIDENT::setIdent_doctype()
     * @uses CServiceIDENT::setNation()
     * @uses CServiceIDENT::setNational_idnum()
     * @uses CServiceIDENT::setSpages()
     * @uses CServiceIDENT::setSsign()
     * @uses CServiceIDENT::setSdealsend()
     * @uses CServiceIDENT::setSdealrec()
     * @param string $name
     * @param string $country
     * @param string $zipcode
     * @param string $city
     * @param string $street
     * @param string $date_birth
     * @param string $identity
     * @param int $ident_doctype
     * @param string $nation
     * @param string $national_idnum
     * @param int $spages
     * @param int $ssign
     * @param int $sdealsend
     * @param int $sdealrec
     */
    public function __construct($name = null, $country = null, $zipcode = null, $city = null, $street = null, $date_birth = null, $identity = null, $ident_doctype = null, $nation = null, $national_idnum = null, $spages = null, $ssign = null, $sdealsend = null, $sdealrec = null)
    {
        $this
            ->setName($name)
            ->setCountry($country)
            ->setZipcode($zipcode)
            ->setCity($city)
            ->setStreet($street)
            ->setDate_birth($date_birth)
            ->setIdentity($identity)
            ->setIdent_doctype($ident_doctype)
            ->setNation($nation)
            ->setNational_idnum($national_idnum)
            ->setSpages($spages)
            ->setSsign($ssign)
            ->setSdealsend($sdealsend)
            ->setSdealrec($sdealrec);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \GLS\CServiceIDENT
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get country value
     * @return string
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \GLS\CServiceIDENT
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get zipcode value
     * @return string
     */
    public function getZipcode()
    {
        return $this->zipcode;
    }
    /**
     * Set zipcode value
     * @param string $zipcode
     * @return \GLS\CServiceIDENT
     */
    public function setZipcode($zipcode = null)
    {
        // validation for constraint: string
        if (!is_null($zipcode) && !is_string($zipcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipcode, true), gettype($zipcode)), __LINE__);
        }
        $this->zipcode = $zipcode;
        return $this;
    }
    /**
     * Get city value
     * @return string
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \GLS\CServiceIDENT
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get street value
     * @return string
     */
    public function getStreet()
    {
        return $this->street;
    }
    /**
     * Set street value
     * @param string $street
     * @return \GLS\CServiceIDENT
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street, true), gettype($street)), __LINE__);
        }
        $this->street = $street;
        return $this;
    }
    /**
     * Get date_birth value
     * @return string|null
     */
    public function getDate_birth()
    {
        return $this->date_birth;
    }
    /**
     * Set date_birth value
     * @param string $date_birth
     * @return \GLS\CServiceIDENT
     */
    public function setDate_birth($date_birth = null)
    {
        // validation for constraint: string
        if (!is_null($date_birth) && !is_string($date_birth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date_birth, true), gettype($date_birth)), __LINE__);
        }
        $this->date_birth = $date_birth;
        return $this;
    }
    /**
     * Get identity value
     * @return string|null
     */
    public function getIdentity()
    {
        return $this->identity;
    }
    /**
     * Set identity value
     * @param string $identity
     * @return \GLS\CServiceIDENT
     */
    public function setIdentity($identity = null)
    {
        // validation for constraint: string
        if (!is_null($identity) && !is_string($identity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identity, true), gettype($identity)), __LINE__);
        }
        $this->identity = $identity;
        return $this;
    }
    /**
     * Get ident_doctype value
     * @return int|null
     */
    public function getIdent_doctype()
    {
        return $this->ident_doctype;
    }
    /**
     * Set ident_doctype value
     * @param int $ident_doctype
     * @return \GLS\CServiceIDENT
     */
    public function setIdent_doctype($ident_doctype = null)
    {
        // validation for constraint: int
        if (!is_null($ident_doctype) && !(is_int($ident_doctype) || ctype_digit($ident_doctype))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ident_doctype, true), gettype($ident_doctype)), __LINE__);
        }
        $this->ident_doctype = $ident_doctype;
        return $this;
    }
    /**
     * Get nation value
     * @return string|null
     */
    public function getNation()
    {
        return $this->nation;
    }
    /**
     * Set nation value
     * @param string $nation
     * @return \GLS\CServiceIDENT
     */
    public function setNation($nation = null)
    {
        // validation for constraint: string
        if (!is_null($nation) && !is_string($nation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nation, true), gettype($nation)), __LINE__);
        }
        $this->nation = $nation;
        return $this;
    }
    /**
     * Get national_idnum value
     * @return string|null
     */
    public function getNational_idnum()
    {
        return $this->national_idnum;
    }
    /**
     * Set national_idnum value
     * @param string $national_idnum
     * @return \GLS\CServiceIDENT
     */
    public function setNational_idnum($national_idnum = null)
    {
        // validation for constraint: string
        if (!is_null($national_idnum) && !is_string($national_idnum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($national_idnum, true), gettype($national_idnum)), __LINE__);
        }
        $this->national_idnum = $national_idnum;
        return $this;
    }
    /**
     * Get spages value
     * @return int|null
     */
    public function getSpages()
    {
        return $this->spages;
    }
    /**
     * Set spages value
     * @param int $spages
     * @return \GLS\CServiceIDENT
     */
    public function setSpages($spages = null)
    {
        // validation for constraint: int
        if (!is_null($spages) && !(is_int($spages) || ctype_digit($spages))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($spages, true), gettype($spages)), __LINE__);
        }
        $this->spages = $spages;
        return $this;
    }
    /**
     * Get ssign value
     * @return int|null
     */
    public function getSsign()
    {
        return $this->ssign;
    }
    /**
     * Set ssign value
     * @param int $ssign
     * @return \GLS\CServiceIDENT
     */
    public function setSsign($ssign = null)
    {
        // validation for constraint: int
        if (!is_null($ssign) && !(is_int($ssign) || ctype_digit($ssign))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ssign, true), gettype($ssign)), __LINE__);
        }
        $this->ssign = $ssign;
        return $this;
    }
    /**
     * Get sdealsend value
     * @return int|null
     */
    public function getSdealsend()
    {
        return $this->sdealsend;
    }
    /**
     * Set sdealsend value
     * @param int $sdealsend
     * @return \GLS\CServiceIDENT
     */
    public function setSdealsend($sdealsend = null)
    {
        // validation for constraint: int
        if (!is_null($sdealsend) && !(is_int($sdealsend) || ctype_digit($sdealsend))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sdealsend, true), gettype($sdealsend)), __LINE__);
        }
        $this->sdealsend = $sdealsend;
        return $this;
    }
    /**
     * Get sdealrec value
     * @return int|null
     */
    public function getSdealrec()
    {
        return $this->sdealrec;
    }
    /**
     * Set sdealrec value
     * @param int $sdealrec
     * @return \GLS\CServiceIDENT
     */
    public function setSdealrec($sdealrec = null)
    {
        // validation for constraint: int
        if (!is_null($sdealrec) && !(is_int($sdealrec) || ctype_digit($sdealrec))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sdealrec, true), gettype($sdealrec)), __LINE__);
        }
        $this->sdealrec = $sdealrec;
        return $this;
    }
}
