<?php

namespace GLS;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cServiceDAW Struct
 * @subpackage Structs
 */
class CServiceDAW extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $name;
    /**
     * The building
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $building;
    /**
     * The floor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $floor;
    /**
     * The room
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $room;
    /**
     * The phone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $phone;
    /**
     * The altrec
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $altrec;
    /**
     * Constructor method for cServiceDAW
     * @uses CServiceDAW::setName()
     * @uses CServiceDAW::setBuilding()
     * @uses CServiceDAW::setFloor()
     * @uses CServiceDAW::setRoom()
     * @uses CServiceDAW::setPhone()
     * @uses CServiceDAW::setAltrec()
     * @param string $name
     * @param string $building
     * @param string $floor
     * @param string $room
     * @param string $phone
     * @param string $altrec
     */
    public function __construct($name = null, $building = null, $floor = null, $room = null, $phone = null, $altrec = null)
    {
        $this
            ->setName($name)
            ->setBuilding($building)
            ->setFloor($floor)
            ->setRoom($room)
            ->setPhone($phone)
            ->setAltrec($altrec);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \GLS\CServiceDAW
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get building value
     * @return string|null
     */
    public function getBuilding()
    {
        return $this->building;
    }
    /**
     * Set building value
     * @param string $building
     * @return \GLS\CServiceDAW
     */
    public function setBuilding($building = null)
    {
        // validation for constraint: string
        if (!is_null($building) && !is_string($building)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($building, true), gettype($building)), __LINE__);
        }
        $this->building = $building;
        return $this;
    }
    /**
     * Get floor value
     * @return string|null
     */
    public function getFloor()
    {
        return $this->floor;
    }
    /**
     * Set floor value
     * @param string $floor
     * @return \GLS\CServiceDAW
     */
    public function setFloor($floor = null)
    {
        // validation for constraint: string
        if (!is_null($floor) && !is_string($floor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($floor, true), gettype($floor)), __LINE__);
        }
        $this->floor = $floor;
        return $this;
    }
    /**
     * Get room value
     * @return string|null
     */
    public function getRoom()
    {
        return $this->room;
    }
    /**
     * Set room value
     * @param string $room
     * @return \GLS\CServiceDAW
     */
    public function setRoom($room = null)
    {
        // validation for constraint: string
        if (!is_null($room) && !is_string($room)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($room, true), gettype($room)), __LINE__);
        }
        $this->room = $room;
        return $this;
    }
    /**
     * Get phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \GLS\CServiceDAW
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
    /**
     * Get altrec value
     * @return string|null
     */
    public function getAltrec()
    {
        return $this->altrec;
    }
    /**
     * Set altrec value
     * @param string $altrec
     * @return \GLS\CServiceDAW
     */
    public function setAltrec($altrec = null)
    {
        // validation for constraint: string
        if (!is_null($altrec) && !is_string($altrec)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($altrec, true), gettype($altrec)), __LINE__);
        }
        $this->altrec = $altrec;
        return $this;
    }
}
