<?php

namespace GLS;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for cParcelShopArray Array
 * @subpackage Arrays
 */
class CParcelShopArray extends AbstractStructArrayBase
{
    /**
     * The items
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \GLS\CParcelShop[]
     */
    public $items;
    /**
     * Constructor method for cParcelShopArray
     * @uses CParcelShopArray::setItems()
     * @param \GLS\CParcelShop[] $items
     */
    public function __construct(array $items = array())
    {
        $this
            ->setItems($items);
    }
    /**
     * Get items value
     * @return \GLS\CParcelShop[]
     */
    public function getItems()
    {
        return $this->items;
    }
    /**
     * This method is responsible for validating the values passed to the setItems method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItems method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemsForArrayConstraintsFromSetItems(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cParcelShopArrayItemsItem) {
            // validation for constraint: itemType
            if (!$cParcelShopArrayItemsItem instanceof \GLS\CParcelShop) {
                $invalidValues[] = is_object($cParcelShopArrayItemsItem) ? get_class($cParcelShopArrayItemsItem) : sprintf('%s(%s)', gettype($cParcelShopArrayItemsItem), var_export($cParcelShopArrayItemsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The items property can only contain items of type \GLS\CParcelShop, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set items value
     * @throws \InvalidArgumentException
     * @param \GLS\CParcelShop[] $items
     * @return \GLS\CParcelShopArray
     */
    public function setItems(array $items = array())
    {
        // validation for constraint: array
        if ('' !== ($itemsArrayErrorMessage = self::validateItemsForArrayConstraintsFromSetItems($items))) {
            throw new \InvalidArgumentException($itemsArrayErrorMessage, __LINE__);
        }
        $this->items = $items;
        return $this;
    }
    /**
     * Add item to items value
     * @throws \InvalidArgumentException
     * @param \GLS\CParcelShop $item
     * @return \GLS\CParcelShopArray
     */
    public function addToItems(\GLS\CParcelShop $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GLS\CParcelShop) {
            throw new \InvalidArgumentException(sprintf('The items property can only contain items of type \GLS\CParcelShop, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->items[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \GLS\CParcelShop
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \GLS\CParcelShop
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \GLS\CParcelShop
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \GLS\CParcelShop
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \GLS\CParcelShop
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string items
     */
    public function getAttributeName()
    {
        return 'items';
    }
}
