<?php

namespace GLS;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for adeLoginByLocalizationCode Struct
 * Meta information extracted from the WSDL
 * - type: tns:adeLoginByLocalizationCode
 * @subpackage Structs
 */
class AdeLoginByLocalizationCode extends AbstractStructBase
{
    /**
     * The user_name
     * @var string
     */
    public $user_name;
    /**
     * The user_password
     * @var string
     */
    public $user_password;
    /**
     * The localization_code
     * @var string
     */
    public $localization_code;
    /**
     * Constructor method for adeLoginByLocalizationCode
     * @uses AdeLoginByLocalizationCode::setUser_name()
     * @uses AdeLoginByLocalizationCode::setUser_password()
     * @uses AdeLoginByLocalizationCode::setLocalization_code()
     * @param string $user_name
     * @param string $user_password
     * @param string $localization_code
     */
    public function __construct($user_name = null, $user_password = null, $localization_code = null)
    {
        $this
            ->setUser_name($user_name)
            ->setUser_password($user_password)
            ->setLocalization_code($localization_code);
    }
    /**
     * Get user_name value
     * @return string|null
     */
    public function getUser_name()
    {
        return $this->user_name;
    }
    /**
     * Set user_name value
     * @param string $user_name
     * @return \GLS\AdeLoginByLocalizationCode
     */
    public function setUser_name($user_name = null)
    {
        // validation for constraint: string
        if (!is_null($user_name) && !is_string($user_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($user_name, true), gettype($user_name)), __LINE__);
        }
        $this->user_name = $user_name;
        return $this;
    }
    /**
     * Get user_password value
     * @return string|null
     */
    public function getUser_password()
    {
        return $this->user_password;
    }
    /**
     * Set user_password value
     * @param string $user_password
     * @return \GLS\AdeLoginByLocalizationCode
     */
    public function setUser_password($user_password = null)
    {
        // validation for constraint: string
        if (!is_null($user_password) && !is_string($user_password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($user_password, true), gettype($user_password)), __LINE__);
        }
        $this->user_password = $user_password;
        return $this;
    }
    /**
     * Get localization_code value
     * @return string|null
     */
    public function getLocalization_code()
    {
        return $this->localization_code;
    }
    /**
     * Set localization_code value
     * @param string $localization_code
     * @return \GLS\AdeLoginByLocalizationCode
     */
    public function setLocalization_code($localization_code = null)
    {
        // validation for constraint: string
        if (!is_null($localization_code) && !is_string($localization_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($localization_code, true), gettype($localization_code)), __LINE__);
        }
        $this->localization_code = $localization_code;
        return $this;
    }
}
