<?php

namespace GLS;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cPickup Struct
 * @subpackage Structs
 */
class CPickup extends AbstractStructBase
{
    /**
     * The desc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $desc;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $quantity;
    /**
     * The weight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $weight;
    /**
     * The datetime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $datetime;
    /**
     * Constructor method for cPickup
     * @uses CPickup::setDesc()
     * @uses CPickup::setQuantity()
     * @uses CPickup::setWeight()
     * @uses CPickup::setDatetime()
     * @param string $desc
     * @param int $quantity
     * @param float $weight
     * @param string $datetime
     */
    public function __construct($desc = null, $quantity = null, $weight = null, $datetime = null)
    {
        $this
            ->setDesc($desc)
            ->setQuantity($quantity)
            ->setWeight($weight)
            ->setDatetime($datetime);
    }
    /**
     * Get desc value
     * @return string
     */
    public function getDesc()
    {
        return $this->desc;
    }
    /**
     * Set desc value
     * @param string $desc
     * @return \GLS\CPickup
     */
    public function setDesc($desc = null)
    {
        // validation for constraint: string
        if (!is_null($desc) && !is_string($desc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($desc, true), gettype($desc)), __LINE__);
        }
        $this->desc = $desc;
        return $this;
    }
    /**
     * Get quantity value
     * @return int
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param int $quantity
     * @return \GLS\CPickup
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get weight value
     * @return float
     */
    public function getWeight()
    {
        return $this->weight;
    }
    /**
     * Set weight value
     * @param float $weight
     * @return \GLS\CPickup
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: float
        if (!is_null($weight) && !(is_float($weight) || is_numeric($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->weight = $weight;
        return $this;
    }
    /**
     * Get datetime value
     * @return string
     */
    public function getDatetime()
    {
        return $this->datetime;
    }
    /**
     * Set datetime value
     * @param string $datetime
     * @return \GLS\CPickup
     */
    public function setDatetime($datetime = null)
    {
        // validation for constraint: string
        if (!is_null($datetime) && !is_string($datetime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datetime, true), gettype($datetime)), __LINE__);
        }
        $this->datetime = $datetime;
        return $this;
    }
}
