<?php

namespace GLS;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cIdent Struct
 * @subpackage Structs
 */
class CIdent extends AbstractStructBase
{
    /**
     * The ident
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ident;
    /**
     * Constructor method for cIdent
     * @uses CIdent::setIdent()
     * @param string $ident
     */
    public function __construct($ident = null)
    {
        $this
            ->setIdent($ident);
    }
    /**
     * Get ident value
     * @return string
     */
    public function getIdent()
    {
        return $this->ident;
    }
    /**
     * Set ident value
     * @param string $ident
     * @return \GLS\CIdent
     */
    public function setIdent($ident = null)
    {
        // validation for constraint: string
        if (!is_null($ident) && !is_string($ident)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ident, true), gettype($ident)), __LINE__);
        }
        $this->ident = $ident;
        return $this;
    }
}
