<?php

namespace GLS;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cConsign Struct
 * @subpackage Structs
 */
class CConsign extends AbstractStructBase
{
    /**
     * The rname1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $rname1;
    /**
     * The rcountry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $rcountry;
    /**
     * The rzipcode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $rzipcode;
    /**
     * The rcity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $rcity;
    /**
     * The rstreet
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $rstreet;
    /**
     * The rname2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $rname2;
    /**
     * The rname3
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $rname3;
    /**
     * The rphone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $rphone;
    /**
     * The rcontact
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $rcontact;
    /**
     * The references
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $references;
    /**
     * The notes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $notes;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $quantity;
    /**
     * The weight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $weight;
    /**
     * The date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $date;
    /**
     * The pfc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pfc;
    /**
     * The sendaddr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \GLS\CSenderAddress
     */
    public $sendaddr;
    /**
     * The srv_ade
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $srv_ade;
    /**
     * The srv_bool
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \GLS\CServicesBool
     */
    public $srv_bool;
    /**
     * The srv_daw
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \GLS\CServiceDAW
     */
    public $srv_daw;
    /**
     * The srv_ident
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \GLS\CServiceIDENT
     */
    public $srv_ident;
    /**
     * The srv_ppe
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \GLS\CServicePPE
     */
    public $srv_ppe;
    /**
     * The srv_sds
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \GLS\CServiceSDS
     */
    public $srv_sds;
    /**
     * The parcels
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \GLS\CParcelsArray
     */
    public $parcels;
    /**
     * Constructor method for cConsign
     * @uses CConsign::setRname1()
     * @uses CConsign::setRcountry()
     * @uses CConsign::setRzipcode()
     * @uses CConsign::setRcity()
     * @uses CConsign::setRstreet()
     * @uses CConsign::setRname2()
     * @uses CConsign::setRname3()
     * @uses CConsign::setRphone()
     * @uses CConsign::setRcontact()
     * @uses CConsign::setReferences()
     * @uses CConsign::setNotes()
     * @uses CConsign::setQuantity()
     * @uses CConsign::setWeight()
     * @uses CConsign::setDate()
     * @uses CConsign::setPfc()
     * @uses CConsign::setSendaddr()
     * @uses CConsign::setSrv_ade()
     * @uses CConsign::setSrv_bool()
     * @uses CConsign::setSrv_daw()
     * @uses CConsign::setSrv_ident()
     * @uses CConsign::setSrv_ppe()
     * @uses CConsign::setSrv_sds()
     * @uses CConsign::setParcels()
     * @param string $rname1
     * @param string $rcountry
     * @param string $rzipcode
     * @param string $rcity
     * @param string $rstreet
     * @param string $rname2
     * @param string $rname3
     * @param string $rphone
     * @param string $rcontact
     * @param string $references
     * @param string $notes
     * @param int $quantity
     * @param float $weight
     * @param string $date
     * @param string $pfc
     * @param \GLS\CSenderAddress $sendaddr
     * @param string $srv_ade
     * @param \GLS\CServicesBool $srv_bool
     * @param \GLS\CServiceDAW $srv_daw
     * @param \GLS\CServiceIDENT $srv_ident
     * @param \GLS\CServicePPE $srv_ppe
     * @param \GLS\CServiceSDS $srv_sds
     * @param \GLS\CParcelsArray $parcels
     */
    public function __construct($rname1 = null, $rcountry = null, $rzipcode = null, $rcity = null, $rstreet = null, $rname2 = null, $rname3 = null, $rphone = null, $rcontact = null, $references = null, $notes = null, $quantity = null, $weight = null, $date = null, $pfc = null, \GLS\CSenderAddress $sendaddr = null, $srv_ade = null, \GLS\CServicesBool $srv_bool = null, \GLS\CServiceDAW $srv_daw = null, \GLS\CServiceIDENT $srv_ident = null, \GLS\CServicePPE $srv_ppe = null, \GLS\CServiceSDS $srv_sds = null, \GLS\CParcelsArray $parcels = null)
    {
        $this
            ->setRname1($rname1)
            ->setRcountry($rcountry)
            ->setRzipcode($rzipcode)
            ->setRcity($rcity)
            ->setRstreet($rstreet)
            ->setRname2($rname2)
            ->setRname3($rname3)
            ->setRphone($rphone)
            ->setRcontact($rcontact)
            ->setReferences($references)
            ->setNotes($notes)
            ->setQuantity($quantity)
            ->setWeight($weight)
            ->setDate($date)
            ->setPfc($pfc)
            ->setSendaddr($sendaddr)
            ->setSrv_ade($srv_ade)
            ->setSrv_bool($srv_bool)
            ->setSrv_daw($srv_daw)
            ->setSrv_ident($srv_ident)
            ->setSrv_ppe($srv_ppe)
            ->setSrv_sds($srv_sds)
            ->setParcels($parcels);
    }
    /**
     * Get rname1 value
     * @return string
     */
    public function getRname1()
    {
        return $this->rname1;
    }
    /**
     * Set rname1 value
     * @param string $rname1
     * @return \GLS\CConsign
     */
    public function setRname1($rname1 = null)
    {
        // validation for constraint: string
        if (!is_null($rname1) && !is_string($rname1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rname1, true), gettype($rname1)), __LINE__);
        }
        $this->rname1 = $rname1;
        return $this;
    }
    /**
     * Get rcountry value
     * @return string
     */
    public function getRcountry()
    {
        return $this->rcountry;
    }
    /**
     * Set rcountry value
     * @param string $rcountry
     * @return \GLS\CConsign
     */
    public function setRcountry($rcountry = null)
    {
        // validation for constraint: string
        if (!is_null($rcountry) && !is_string($rcountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rcountry, true), gettype($rcountry)), __LINE__);
        }
        $this->rcountry = $rcountry;
        return $this;
    }
    /**
     * Get rzipcode value
     * @return string
     */
    public function getRzipcode()
    {
        return $this->rzipcode;
    }
    /**
     * Set rzipcode value
     * @param string $rzipcode
     * @return \GLS\CConsign
     */
    public function setRzipcode($rzipcode = null)
    {
        // validation for constraint: string
        if (!is_null($rzipcode) && !is_string($rzipcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rzipcode, true), gettype($rzipcode)), __LINE__);
        }
        $this->rzipcode = $rzipcode;
        return $this;
    }
    /**
     * Get rcity value
     * @return string
     */
    public function getRcity()
    {
        return $this->rcity;
    }
    /**
     * Set rcity value
     * @param string $rcity
     * @return \GLS\CConsign
     */
    public function setRcity($rcity = null)
    {
        // validation for constraint: string
        if (!is_null($rcity) && !is_string($rcity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rcity, true), gettype($rcity)), __LINE__);
        }
        $this->rcity = $rcity;
        return $this;
    }
    /**
     * Get rstreet value
     * @return string
     */
    public function getRstreet()
    {
        return $this->rstreet;
    }
    /**
     * Set rstreet value
     * @param string $rstreet
     * @return \GLS\CConsign
     */
    public function setRstreet($rstreet = null)
    {
        // validation for constraint: string
        if (!is_null($rstreet) && !is_string($rstreet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rstreet, true), gettype($rstreet)), __LINE__);
        }
        $this->rstreet = $rstreet;
        return $this;
    }
    /**
     * Get rname2 value
     * @return string|null
     */
    public function getRname2()
    {
        return $this->rname2;
    }
    /**
     * Set rname2 value
     * @param string $rname2
     * @return \GLS\CConsign
     */
    public function setRname2($rname2 = null)
    {
        // validation for constraint: string
        if (!is_null($rname2) && !is_string($rname2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rname2, true), gettype($rname2)), __LINE__);
        }
        $this->rname2 = $rname2;
        return $this;
    }
    /**
     * Get rname3 value
     * @return string|null
     */
    public function getRname3()
    {
        return $this->rname3;
    }
    /**
     * Set rname3 value
     * @param string $rname3
     * @return \GLS\CConsign
     */
    public function setRname3($rname3 = null)
    {
        // validation for constraint: string
        if (!is_null($rname3) && !is_string($rname3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rname3, true), gettype($rname3)), __LINE__);
        }
        $this->rname3 = $rname3;
        return $this;
    }
    /**
     * Get rphone value
     * @return string|null
     */
    public function getRphone()
    {
        return $this->rphone;
    }
    /**
     * Set rphone value
     * @param string $rphone
     * @return \GLS\CConsign
     */
    public function setRphone($rphone = null)
    {
        // validation for constraint: string
        if (!is_null($rphone) && !is_string($rphone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rphone, true), gettype($rphone)), __LINE__);
        }
        $this->rphone = $rphone;
        return $this;
    }
    /**
     * Get rcontact value
     * @return string|null
     */
    public function getRcontact()
    {
        return $this->rcontact;
    }
    /**
     * Set rcontact value
     * @param string $rcontact
     * @return \GLS\CConsign
     */
    public function setRcontact($rcontact = null)
    {
        // validation for constraint: string
        if (!is_null($rcontact) && !is_string($rcontact)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rcontact, true), gettype($rcontact)), __LINE__);
        }
        $this->rcontact = $rcontact;
        return $this;
    }
    /**
     * Get references value
     * @return string|null
     */
    public function getReferences()
    {
        return $this->references;
    }
    /**
     * Set references value
     * @param string $references
     * @return \GLS\CConsign
     */
    public function setReferences($references = null)
    {
        // validation for constraint: string
        if (!is_null($references) && !is_string($references)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($references, true), gettype($references)), __LINE__);
        }
        $this->references = $references;
        return $this;
    }
    /**
     * Get notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->notes;
    }
    /**
     * Set notes value
     * @param string $notes
     * @return \GLS\CConsign
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        $this->notes = $notes;
        return $this;
    }
    /**
     * Get quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param int $quantity
     * @return \GLS\CConsign
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get weight value
     * @return float|null
     */
    public function getWeight()
    {
        return $this->weight;
    }
    /**
     * Set weight value
     * @param float $weight
     * @return \GLS\CConsign
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: float
        if (!is_null($weight) && !(is_float($weight) || is_numeric($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->weight = $weight;
        return $this;
    }
    /**
     * Get date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \GLS\CConsign
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get pfc value
     * @return string|null
     */
    public function getPfc()
    {
        return $this->pfc;
    }
    /**
     * Set pfc value
     * @param string $pfc
     * @return \GLS\CConsign
     */
    public function setPfc($pfc = null)
    {
        // validation for constraint: string
        if (!is_null($pfc) && !is_string($pfc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pfc, true), gettype($pfc)), __LINE__);
        }
        $this->pfc = $pfc;
        return $this;
    }
    /**
     * Get sendaddr value
     * @return \GLS\CSenderAddress|null
     */
    public function getSendaddr()
    {
        return $this->sendaddr;
    }
    /**
     * Set sendaddr value
     * @param \GLS\CSenderAddress $sendaddr
     * @return \GLS\CConsign
     */
    public function setSendaddr(\GLS\CSenderAddress $sendaddr = null)
    {
        $this->sendaddr = $sendaddr;
        return $this;
    }
    /**
     * Get srv_ade value
     * @return string|null
     */
    public function getSrv_ade()
    {
        return $this->srv_ade;
    }
    /**
     * Set srv_ade value
     * @param string $srv_ade
     * @return \GLS\CConsign
     */
    public function setSrv_ade($srv_ade = null)
    {
        // validation for constraint: string
        if (!is_null($srv_ade) && !is_string($srv_ade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($srv_ade, true), gettype($srv_ade)), __LINE__);
        }
        $this->srv_ade = $srv_ade;
        return $this;
    }
    /**
     * Get srv_bool value
     * @return \GLS\CServicesBool|null
     */
    public function getSrv_bool()
    {
        return $this->srv_bool;
    }
    /**
     * Set srv_bool value
     * @param \GLS\CServicesBool $srv_bool
     * @return \GLS\CConsign
     */
    public function setSrv_bool(\GLS\CServicesBool $srv_bool = null)
    {
        $this->srv_bool = $srv_bool;
        return $this;
    }
    /**
     * Get srv_daw value
     * @return \GLS\CServiceDAW|null
     */
    public function getSrv_daw()
    {
        return $this->srv_daw;
    }
    /**
     * Set srv_daw value
     * @param \GLS\CServiceDAW $srv_daw
     * @return \GLS\CConsign
     */
    public function setSrv_daw(\GLS\CServiceDAW $srv_daw = null)
    {
        $this->srv_daw = $srv_daw;
        return $this;
    }
    /**
     * Get srv_ident value
     * @return \GLS\CServiceIDENT|null
     */
    public function getSrv_ident()
    {
        return $this->srv_ident;
    }
    /**
     * Set srv_ident value
     * @param \GLS\CServiceIDENT $srv_ident
     * @return \GLS\CConsign
     */
    public function setSrv_ident(\GLS\CServiceIDENT $srv_ident = null)
    {
        $this->srv_ident = $srv_ident;
        return $this;
    }
    /**
     * Get srv_ppe value
     * @return \GLS\CServicePPE|null
     */
    public function getSrv_ppe()
    {
        return $this->srv_ppe;
    }
    /**
     * Set srv_ppe value
     * @param \GLS\CServicePPE $srv_ppe
     * @return \GLS\CConsign
     */
    public function setSrv_ppe(\GLS\CServicePPE $srv_ppe = null)
    {
        $this->srv_ppe = $srv_ppe;
        return $this;
    }
    /**
     * Get srv_sds value
     * @return \GLS\CServiceSDS|null
     */
    public function getSrv_sds()
    {
        return $this->srv_sds;
    }
    /**
     * Set srv_sds value
     * @param \GLS\CServiceSDS $srv_sds
     * @return \GLS\CConsign
     */
    public function setSrv_sds(\GLS\CServiceSDS $srv_sds = null)
    {
        $this->srv_sds = $srv_sds;
        return $this;
    }
    /**
     * Get parcels value
     * @return \GLS\CParcelsArray|null
     */
    public function getParcels()
    {
        return $this->parcels;
    }
    /**
     * Set parcels value
     * @param \GLS\CParcelsArray $parcels
     * @return \GLS\CConsign
     */
    public function setParcels(\GLS\CParcelsArray $parcels = null)
    {
        $this->parcels = $parcels;
        return $this;
    }
}
