<?php

namespace GLS;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cReceipt Struct
 * @subpackage Structs
 */
class CReceipt extends AbstractStructBase
{
    /**
     * The receipt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $receipt;
    /**
     * Constructor method for cReceipt
     * @uses CReceipt::setReceipt()
     * @param string $receipt
     */
    public function __construct($receipt = null)
    {
        $this
            ->setReceipt($receipt);
    }
    /**
     * Get receipt value
     * @return string
     */
    public function getReceipt()
    {
        return $this->receipt;
    }
    /**
     * Set receipt value
     * @param string $receipt
     * @return \GLS\CReceipt
     */
    public function setReceipt($receipt = null)
    {
        // validation for constraint: string
        if (!is_null($receipt) && !is_string($receipt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receipt, true), gettype($receipt)), __LINE__);
        }
        $this->receipt = $receipt;
        return $this;
    }
}
